<?php
/*
 web-vision GmbH
 Do not edit or add to this file if you wish to upgrade Magento to newer
 versions in the future. If you wish to customize Magento for your
 needs please refer to https://www.web-vision.de for more information.
 @category    Extendware
 @copyright   Copyright (c) 2001-2023 web-vision GmbH (https://www.web-vision.de)
 @author      Bushra Asif <ba@web-vision.de>
*/

declare(strict_types=1);

namespace Extendware\ContactUsTracker\Model;

use Extendware\ContactUsTracker\Model\ResourceModel\ContactUs as ContactUsResource;
use Magento\Framework\Model\AbstractModel;

class ContactUs extends AbstractModel
{
    /**
     * Initialize model
     */
    protected function _construct(): void
    {
        $this->_init(ContactUsResource::class);
    }

    public function getLastName(): ?string
    {
        return $this->getData('lastname');
    }

    public function setLastName(?string $lastname): self
    {
        return $this->setData('lastname', $lastname);
    }

    public function getSubject(): ?string
    {
        return $this->getData('subject');
    }

    public function setSubject(?string $subject): self
    {
        return $this->setData('subject', $subject);
    }
}
