<?php
/*
 web-vision GmbH
 Do not edit or add to this file if you wish to upgrade Magento to newer
 versions in the future. If you wish to customize Magento for your
 needs please refer to https://www.web-vision.de for more information.
 @category    Extendware
 @copyright   Copyright (c) 2001-2023 web-vision GmbH (https://www.web-vision.de)
 @author      Bushra Asif <ba@web-vision.de>
*/

declare(strict_types=1);

namespace Extendware\ContactUsTracker\Model;

use Extendware\ContactUsTracker\Model\ResourceModel\ContactUs as ContactUsResource;
use Magento\Framework\Exception\CouldNotSaveException;
use Magento\Framework\Exception\NoSuchEntityException;

class Repository
{
    public function __construct(
        private ContactUsResource $resource,
        private ContactUsFactory $contactUsFactory
    ) {}

    public function createEmptyModel(): ContactUs
    {
        return $this->contactUsFactory->create();
    }

    public function save(ContactUs $contactUs): void
    {
        try {
            $this->resource->save($contactUs);
        } catch (\Exception $e) {
            throw new CouldNotSaveException(__('Could not save the contact us entity: %1', $e->getMessage()), $e);
        }
    }

    public function getById($id)
    {
        $contactUs = $this->createEmptyModel();
        $this->resource->load($contactUs, $id);
        if (!$contactUs->getId()) {
            throw new NoSuchEntityException(__('Contact Us with id "%1" does not exist.', $id));
        }
        return $contactUs;
    }
    public function deleteById($id): void
    {
        $contactUs = $this->getById($id);
        $this->resource->delete($contactUs);
    }
}
