<?php
/*
 web-vision GmbH
 Do not edit or add to this file if you wish to upgrade Magento to newer
 versions in the future. If you wish to customize Magento for your
 needs please refer to https://www.web-vision.de for more information.
 @category    Extendware
 @copyright   Copyright (c) 2001-2023 web-vision GmbH (https://www.web-vision.de)
 @author      Bushra Asif <ba@web-vision.de>
*/

declare(strict_types=1);

namespace Extendware\ContactUsTracker\Model\ResourceModel;

use Magento\Framework\Exception\LocalizedException;
use Magento\Framework\Model\ResourceModel\Db\AbstractDb;

class ContactUs extends AbstractDb
{

    /**
     * Init main table
     */
    protected function _construct(): void
    {
        $this->_init('contact_us_tracker', 'entity_id');
    }

    /**
     * Mass delete
     *
     * @throws LocalizedException
     */
    public function massDelete(array $ids): void
    {
        $this->getConnection()->delete($this->getMainTable(), ['entity_id IN (?)' => $ids]);
    }
}
