<?php
/*
 web-vision GmbH
 Do not edit or add to this file if you wish to upgrade Magento to newer
 versions in the future. If you wish to customize Magento for your
 needs please refer to https://www.web-vision.de for more information.
 @category    Extendware
 @copyright   Copyright (c) 2001-2023 web-vision GmbH (https://www.web-vision.de)
 @author      Bushra Asif <ba@web-vision.de>
*/

declare(strict_types=1);

namespace Extendware\ContactUsTracker\Model\ResourceModel\Grid;

use Extendware\ContactUsTracker\Model\ResourceModel\ContactUs;
use Magento\Framework\Data\Collection\Db\FetchStrategyInterface as FetchStrategy;
use Magento\Framework\Data\Collection\EntityFactoryInterface as EntityFactory;
use Magento\Framework\Event\ManagerInterface as EventManager;
use Magento\Framework\View\Element\UiComponent\DataProvider\SearchResult;
use Psr\Log\LoggerInterface as Logger;

class Collection extends SearchResult
{
    public function __construct(
        EntityFactory $entityFactory,
        Logger $logger,
        FetchStrategy $fetchStrategy,
        EventManager $eventManager,
        string $mainTable = 'contact_us_tracker',
        string $resourceModel = ContactUs::class,
        ?string $connectionName = null,
        ?string $identifierName = null,
    ) {
        parent::__construct(
            $entityFactory,
            $logger,
            $fetchStrategy,
            $eventManager,
            $mainTable,
            $resourceModel,
            $identifierName,
            $connectionName
        );
    }

    /**
     * Truncate comment line if length is more than 75 characters
     */
    public function getItems(): array
    {
        $items = parent::getItems();

        foreach ($items as $item) {
            $comment = $item->getComment();
            if ($comment !== null && strlen($comment) > 75) {
                $item->setComment(substr($comment, 0, 75) . '...');
            }
        }

        return $items;
    }
}
