<?php
/*
 web-vision GmbH
 Do not edit or add to this file if you wish to upgrade Magento to newer
 versions in the future. If you wish to customize Magento for your
 needs please refer to https://www.web-vision.de for more information.
 @category    Extendware
 @copyright   Copyright (c) 2001-2023 web-vision GmbH (https://www.web-vision.de)
 @author      Bushra Asif <ba@web-vision.de>
*/

declare(strict_types=1);

namespace Extendware\ContactUsTracker\Model\Source;

use Magento\Eav\Model\Entity\Attribute\Source\AbstractSource;
use Magento\Store\Model\StoreManagerInterface;

class Store extends AbstractSource
{
    public function __construct(protected StoreManagerInterface $storeManager)
    {
    }

    /**
     * Get all stores
     */
    public function getAllOptions(): array
    {
        if ($this->_options) {
            return $this->_options;
        }

        $this->_options = $this->toOptionArray();
        return $this->_options;
    }

    /**
     * To option array
     */
    public function toOptionArray(): array
    {
        $options = [];

        foreach ($this->storeManager->getStores() as $store) {
            $options[] = ['label' => $store->getName(), 'value' => $store->getId()];
        }

        return $options;
    }
}
