<?php
/*
 web-vision GmbH
 Do not edit or add to this file if you wish to upgrade Magento to newer
 versions in the future. If you wish to customize Magento for your
 needs please refer to https://www.web-vision.de for more information.
 @category    Extendware
 @copyright   Copyright (c) 2001-2023 web-vision GmbH (https://www.web-vision.de)
 @author      Bushra Asif <ba@web-vision.de>
*/

declare(strict_types=1);

namespace Extendware\ContactUsTracker\Ui\DataProvider\Form;

use Extendware\ContactUsTracker\Model\ResourceModel\ContactUs\Collection;
use Extendware\ContactUsTracker\Model\ResourceModel\ContactUs\CollectionFactory;
use Magento\Store\Model\StoreManagerInterface;
use Magento\Ui\DataProvider\AbstractDataProvider;

class DataProvider extends AbstractDataProvider
{
    protected array $loadedData = [];

    /** @var Collection */
    protected $collection; // phpcs:ignore

    public function __construct(
        string $name,
        string $primaryFieldName,
        string $requestFieldName,
        CollectionFactory $collectionFactory,
        protected StoreManagerInterface $storeManager,
        array $meta = [],
        array $data = []
    ) {
        $this->collection = $collectionFactory->create();
        parent::__construct($name, $primaryFieldName, $requestFieldName, $meta, $data);
    }

    /**
     * Get data
     */
    public function getData(): array
    {
        if (!empty($this->loadedData)) {
            return $this->loadedData;
        }

        $items = $this->collection->getItems();
        $storeMapping = $this->getStoreMapping();
        foreach ($items as $item) {
            $storeId = $item->getStoreId();
            $this->loadedData[$item->getId()] = $item->getData();
            $this->loadedData[$item->getId()]['store_name'] = $storeMapping[$storeId] ?? $storeId;
        }

        return $this->loadedData;
    }

    /**
     * Get store mapping
     */
    protected function getStoreMapping(): array
    {
        $storeMapping = [];

        foreach ($this->storeManager->getStores() as $store) {
            $storeMapping[$store->getId()] = $store->getName();
        }

        return $storeMapping;
    }
}
