<?php

declare(strict_types=1);
namespace Extendware\EWBotBlocker\Block\Adminhtml;

/**
 * Extendware by web-vision GmbH
 *
 * NOTICE OF LICENSE
 *
 * <!--LICENSETEXT-->
 *
 * DISCLAIMER
 *
 * Do not edit or add to this file if you wish to upgrade Magento to newer
 * versions in the future. If you wish to customize Magento for youre
 * needs please refer to https://www.extendware.com/magento-custom-development.html for more information.
 *
 * @category ExtendWare_EWBotBlocker
 *
 * @copyright (c) 2001-2021 Extendware by web-vision GmbH (https://extendware.com/)
 * @license https://support.extendware.com/
 * @affilate https://www.extendware.com/affiliate
 *
 * @author Vaibhav Ahalpara <vaibhav@web-vision.de>
 */
class EWbots extends \Magento\Backend\Block\Widget\Container
{
    /**
     * @var string
     */
    protected $_template = 'ewbots/ewbots.phtml';

    /**
     * @param \Magento\Backend\Block\Widget\Context $context
     * @param array $data
     */
    public function __construct(\Magento\Backend\Block\Widget\Context $context, array $data = [])
    {
        parent::__construct($context, $data);
    }

    /**
     * Prepare button and grid
     *
     * @return $this
     */
    protected function _prepareLayout()
    {
        $addButtonProps = [
            'id' => 'add_new',
            'label' => __('Add New Bot'),
            'class' => 'add primary',
            'onclick' => "setLocation('" . $this->_getCreateUrl() . "')",
            'button_class' => '',
        ];
        $this->buttonList->add('add_new', $addButtonProps);


        $this->setChild(
            'grid',
            $this->getLayout()->createBlock('Extendware\EWBotBlocker\Block\Adminhtml\EWbots\Grid', 'extendware.ewbots.grid')
        );

        return parent::_prepareLayout();
    }

    /**
     *
     *
     * @return string
     */
    protected function _getCreateUrl()
    {
        return $this->getUrl(
            'ewbotblocker/*/new'
        );
    }

    /**
     * Render grid
     *
     * @return string
     */
    public function getGridHtml()
    {
        return $this->getChildHtml('grid');
    }
}
