<?php

declare(strict_types=1);
namespace Extendware\EWBotBlocker\Block\Adminhtml\EWbots;

use Magento\Backend\Block\Widget\Context;
use Magento\Backend\Block\Widget\Form\Container;
use Magento\Framework\Registry;

/**
 * Extendware by web-vision GmbH
 *
 * NOTICE OF LICENSE
 *
 * <!--LICENSETEXT-->
 *
 * DISCLAIMER
 *
 * Do not edit or add to this file if you wish to upgrade Magento to newer
 * versions in the future. If you wish to customize Magento for youre
 * needs please refer to https://www.extendware.com/magento-custom-development.html for more information.
 *
 * @category ExtendWare_EWBotBlocker
 *
 * @copyright (c) 2001-2021 Extendware by web-vision GmbH (https://extendware.com/)
 * @license https://support.extendware.com/
 * @affilate https://www.extendware.com/affiliate
 *
 * @author Vaibhav Ahalpara <vaibhav@web-vision.de>
 */
class Edit extends Container
{
    /**
     * Core registry
     *
     * @var \Magento\Framework\Registry
     */
    protected $_coreRegistry = null;

    /**
     * @param \Magento\Backend\Block\Widget\Context $context
     * @param \Magento\Framework\Registry $registry
     * @param array $data
     */
    public function __construct(
        Context $context,
        Registry $registry,
        array $data = []
    ) {
        $this->_coreRegistry = $registry;
        parent::__construct($context, $data);
    }

    /**
     * Initialize ewbots edit block
     *
     * @return void
     */
    protected function _construct()
    {
        $this->_objectId = 'bot_id';
        $this->_blockGroup = 'Extendware_EWBotBlocker';
        $this->_controller = 'adminhtml_EWbots';

        parent::_construct();

        $this->buttonList->update('save', 'label', __('Save Bot'));
        $this->buttonList->add(
            'saveandcontinue',
            [
                'label' => __('Save and Continue Edit'),
                'class' => 'save',
                'data_attribute' => [
                    'mage-init' => [
                        'button' => ['event' => 'saveAndContinueEdit', 'target' => '#edit_form'],
                    ],
                ],
            ],
            -100
        );

        $this->buttonList->update('delete', 'label', __('Delete Bot'));
    }

    /**
     * Retrieve text for header element depending on loaded post
     *
     * @return \Magento\Framework\Phrase
     */
    public function getHeaderText()
    {
        if ($this->_coreRegistry->registry('ewbots')->getId()) {
            return __("Edit Bot '%1'", $this->escapeHtml($this->_coreRegistry->registry('ewbots')->getTitle()));
        }

        return __('New Bot');
    }

    /**
     * Getter of url for "Save and Continue" button
     * tab_id will be replaced by desired by JS later
     *
     * @return string
     */
    protected function _getSaveAndContinueUrl()
    {
        return $this->getUrl('ewbotblocker/*/save', ['_current' => true, 'back' => 'edit', 'active_tab' => '{{tab_id}}']);
    }

    /**
     * Prepare layout
     *
     * @return \Magento\Framework\View\Element\AbstractBlock
     */
    protected function _prepareLayout()
    {
        $this->_formScripts[] = "
            function toggleEditor() {
                if (tinyMCE.getInstanceById('page_content') == null) {
                    tinyMCE.execCommand('mceAddControl', false, 'content');
                } else {
                    tinyMCE.execCommand('mceRemoveControl', false, 'content');
                }
            };
        ";

        return parent::_prepareLayout();
    }
}
