<?php

declare(strict_types=1);
namespace Extendware\EWBotBlocker\Block\Adminhtml\EWbots\Edit\Tab;

use Magento\Backend\Block\Widget\Form\Generic;
use Magento\Backend\Block\Widget\Tab\TabInterface;

/**
 * Extendware by web-vision GmbH
 *
 * NOTICE OF LICENSE
 *
 * <!--LICENSETEXT-->
 *
 * DISCLAIMER
 *
 * Do not edit or add to this file if you wish to upgrade Magento to newer
 * versions in the future. If you wish to customize Magento for youre
 * needs please refer to https://www.extendware.com/magento-custom-development.html for more information.
 *
 * @category ExtendWare_EWBotBlocker
 *
 * @copyright (c) 2001-2021 Extendware by web-vision GmbH (https://extendware.com/)
 * @license https://support.extendware.com/
 * @affilate https://www.extendware.com/affiliate
 *
 * @author Vaibhav Ahalpara <vaibhav@web-vision.de>
 */
class Main extends Generic implements TabInterface
{
    /**
     * @var \Magento\Store\Model\System\Store
     */
    protected $_systemStore;
    /**
     * @var \Magento\Framework\HTTP\PhpEnvironment\Request
     */
    protected $request;
    /**
     * @var \Extendware\EWBotBlocker\Model\Status
     */
    protected $_status;
    /**
     * @var Extendware\EWBotBlocker\Model\EWBotsFactory
     */
    protected $_botsfactory;

    /**
     * @param \Magento\Backend\Block\Template\Context $context
     * @param \Magento\Framework\Registry $registry
     * @param \Magento\Framework\Data\FormFactory $formFactory
     * @param \Magento\Store\Model\System\Store $systemStore
     * @param \Magento\Framework\HTTP\PhpEnvironment\Request $request
     * @param \Extendware\EWBotBlocker\Model\Status $status
     * @param \Extendware\EWBotBlocker\Model\EWBotsFactory $botsfactory
     * @param array $data
     */
    public function __construct(
        \Magento\Backend\Block\Template\Context $context,
        \Magento\Framework\Registry $registry,
        \Magento\Framework\Data\FormFactory $formFactory,
        \Magento\Store\Model\System\Store $systemStore,
        \Magento\Framework\HTTP\PhpEnvironment\Request $request,
        \Extendware\EWBotBlocker\Model\Status $status,
        \Extendware\EWBotBlocker\Model\EWBotsFactory $botsfactory,
        array $data = []
    ) {
        $this->_systemStore = $systemStore;
        $this->request = $request;
        $this->_botsfactory = $botsfactory;
        $this->_status = $status;
        parent::__construct($context, $registry, $formFactory, $data);
    }

    /**
     * Prepare form
     *
     * @return $this
     * @SuppressWarnings(PHPMD.ExcessiveMethodLength)
     */
    protected function _prepareForm()
    {
        $isElementDisabled = false;

        /** @var \Magento\Framework\Data\Form $form */
        $form = $this->_formFactory->create();

        $form->setHtmlIdPrefix('page_');

        $fieldset = $form->addFieldset('base_fieldset', ['legend' => __('Bot Information')]);
        $model = $this->_botsfactory->create();
        $expires_at = '';
        if ($id = $this->getRequest()->getParam('bot_id')) {
            $model = $model->load($id);
            $fieldset->addField('bot_id', 'hidden', ['name' => 'bot_id', 'value' => $model->getId()]);
            $date = strtotime($model->getExpiresAt());
            $currdt = strtotime($model->getCreatedAt());
            $expires_at = (strtotime($model->getExpiresAt()) - strtotime($model->getCreatedAt())) / (60 * 60 * 24);
        }


        $fieldset->addField(
            'ip',
            'text',
            [
                'name' => 'ip',
                'label' => __('IP Address'),
                'title' => __('IP Address'),
                'required' => true,
                'value' => $model->getIp(),
            ]
        );
        $fieldset->addField(
            'status',
            'select',
            [
             'name' => 'status',
             'label' => __('Status'),
             'title' => __('Status'),
             'values' => $this->_status->getOptionArray(),
             'value' => $model->getStatus(),
            ]
        );
        $fieldset->addField(
            'permanently_block',
            'select',
            [
             'name' => 'permanently_block',
             'label' => __('Permanently Block'),
             'title' => __('Permanently Block'),
             'values' => [
                                ['value' => 0, 'label' => __('No')],
                                ['value' => 1, 'label' => __('Yes')],
                            ],
             'value' => $model->getPermanentlyBlock(),
            ]
        );

        $fieldset->addField('expires_at', 'text', [
            'name' => 'expires_at',
            'label' => __('No of days after bot expires'),
            'value' => $expires_at,
            'type' => 'number',
            'required' => true,
            'min' => 1,
            'class' => 'validate-number validate-greater-than-zero integer',
        ]);


        if (!$model->getId()) {
            $model->setData('is_active', $isElementDisabled ? '0' : '1');
        }

        $this->setForm($form);

        return parent::_prepareForm();
    }

    /**
     * Prepare label for tab
     *
     * @return \Magento\Framework\Phrase
     */
    public function getTabLabel()
    {
        return __('Bot Information');
    }

    /**
     * Prepare title for tab
     *
     * @return \Magento\Framework\Phrase
     */
    public function getTabTitle()
    {
        return __('Bot Information');
    }

    /**
     * {@inheritdoc}
     */
    public function canShowTab()
    {
        return true;
    }

    /**
     * {@inheritdoc}
     */
    public function isHidden()
    {
        return false;
    }

    /**
     * Check permission for passed action
     *
     * @param string $resourceId
     *
     * @return bool
     */
    protected function _isAllowedAction($resourceId)
    {
        return $this->_authorization->isAllowed($resourceId);
    }

    public function getTargetOptionArray()
    {
        return [
                    '_self' => 'Self',
                    '_blank' => 'New Page',
                    ];
    }
}
