<?php

declare(strict_types=1);
namespace Extendware\EWBotBlocker\Block\Adminhtml\Form\Field;

use Magento\Config\Block\System\Config\Form\Field\FieldArray\AbstractFieldArray;
use Magento\Framework\DataObject;
use Magento\Framework\Exception\LocalizedException;

/**
 * Extendware by web-vision GmbH
 *
 * NOTICE OF LICENSE
 *
 * <!--LICENSETEXT-->
 *
 * DISCLAIMER
 *
 * Do not edit or add to this file if you wish to upgrade Magento to newer
 * versions in the future. If you wish to customize Magento for youre
 * needs please refer to https://www.extendware.com/magento-custom-development.html for more information.
 *
 * @category ExtendWare_EWBotBlocker
 *
 * @copyright (c) 2001-2021 Extendware by web-vision GmbH (https://extendware.com/)
 * @license https://support.extendware.com/
 * @affilate https://www.extendware.com/affiliate
 *
 * @author Vaibhav Ahalpara <vaibhav@web-vision.de>
 */
class Ranges extends AbstractFieldArray
{
    /**
     * @var TypeColumn
     */
    private $typeRenderer;

    /**
     * Prepare rendering the new field by adding all the needed columns
     *
     * @return void
     */
    protected function _prepareToRender()
    {
        $this->addColumn('keyword', ['label' => __('Keywords'), 'class' => 'required-entry']);
        $this->addColumn('type', [
            'label' => __('Type'),
            'renderer' => $this->getTypeRenderer(),
        ]);
        $this->_addAfter = false;
        $this->_addButtonLabel = __('Add');
    }

    /**
     * Prepare existing row data object
     *
     * @param DataObject $row
     *
     * @throws LocalizedException
     *
     * @return void
     */
    protected function _prepareArrayRow(DataObject $row): void
    {
        $options = [];

        $type = $row->getType();
        if ($type !== null) {
            $options['option_' . $this->getTypeRenderer()->calcOptionHash($type)] = 'selected="selected"';
        }

        $row->setData('option_extra_attrs', $options);
    }

    /**
     * @throws LocalizedException
     *
     * @return TypeColumn
     */
    private function getTypeRenderer()
    {
        if (!$this->typeRenderer) {
            $this->typeRenderer = $this->getLayout()->createBlock(
                TypeColumn::class,
                '',
                ['data' => ['is_render_to_js_template' => true]]
            );
        }

        return $this->typeRenderer;
    }
}
