<?php
/*
 * web-vision GmbH
 * Do not edit or add to this file if you wish to upgrade Magento to newer
 * versions in the future. If you wish to customize Magento for your
 * needs please refer to https://www.web-vision.de for more information.
 * @category    Extendware
 * @copyright   Copyright (c) 2001-2023 web-vision GmbH (https://www.web-vision.de)
 * @author      Ronan Guérin
 */
declare(strict_types=1);

namespace Extendware\EWBotBlocker\Block\Adminhtml\System;

use Magento\Backend\Block\Context;
use Magento\Backend\Model\Auth\Session;
use Magento\Config\Block\System\Config\Form\Fieldset;
use Magento\Framework\Data\Form\Element\AbstractElement;
use Magento\Framework\Module\Dir;
use Magento\Framework\Serialize\SerializerInterface;
use Magento\Framework\View\Asset\File\NotFoundException;
use Magento\Framework\View\Helper\Js;
use Magento\Framework\View\Helper\SecureHtmlRenderer;
use Psr\Log\LoggerInterface;

class Info extends Fieldset
{
    /**
     * @var Dir
     */
    private Dir $dir;
    private SerializerInterface $serializer;
    private LoggerInterface $logger;

    /**
     * @param Dir $dir
     * @param SerializerInterface $serializer
     * @param LoggerInterface $logger
     * @param Context $context
     * @param Session $authSession
     * @param Js $jsHelper
     * @param array $data
     * @param SecureHtmlRenderer|null $secureRenderer
     */
    public function __construct(
        Dir                 $dir,
        SerializerInterface $serializer,
        LoggerInterface     $logger,
        Context             $context,
        Session             $authSession,
        Js                  $jsHelper,
        array               $data = [],
        ?SecureHtmlRenderer $secureRenderer = null
    )
    {
        parent::__construct($context, $authSession, $jsHelper, $data, $secureRenderer);
        $this->dir = $dir;
        $this->serializer = $serializer;
        $this->logger = $logger;
    }

    /**
     * @param AbstractElement $element
     * @return string
     */
    public function render(AbstractElement $element): string
    {
        $moduleName = $this->getModuleName();
        $modulePath = $this->dir->getDir($moduleName);
        try {
            $file = file_get_contents(sprintf("%s/composer.json", $modulePath));
            if ($file) {
                $data = $this->serializer->unserialize($file);
                if (isset($data["version"]) && $data["version"]) {
                    $logo = $this->getViewFileUrl(sprintf("%s::images/logo.png", $moduleName));
                    return <<<HTML
                    <div style="display: flex; align-items: center; margin-bottom: 2rem;">
                        <div>
                            <img src="{$logo}" alt="{$moduleName}" width="150">
                        </div>
                        <div style="flex:1; text-align: right">
                            <span>v{$data["version"]}</span>
                        </div>
                    </div>
                HTML;
                }
            }
        } catch (NotFoundException $e) {
            $this->logger->debug($e->getMessage());
        }
        return "";
    }
}