<?php

declare(strict_types=1);
namespace Extendware\EWBotBlocker\Block\Index;

use Magento\Framework\App\ActionInterface;
use Magento\Framework\View\Element\Template;

/**
 * Extendware by web-vision GmbH
 *
 * NOTICE OF LICENSE
 *
 * <!--LICENSETEXT-->
 *
 * DISCLAIMER
 *
 * Do not edit or add to this file if you wish to upgrade Magento to newer
 * versions in the future. If you wish to customize Magento for youre
 * needs please refer to https://www.extendware.com/magento-custom-development.html for more information.
 *
 * @category ExtendWare_EWBotBlocker
 *
 * @copyright (c) 2001-2021 Extendware by web-vision GmbH (https://extendware.com/)
 * @license https://support.extendware.com/
 * @affilate https://www.extendware.com/affiliate
 *
 * @author Vaibhav Ahalpara <vaibhav@web-vision.de>
 */
class Validate extends Template
{
    /**
     * @var Extendware\EWBotBlocker\Helper\Config
     */
    protected $ewbotConfigHelper;

    public function __construct(
        \Magento\Catalog\Block\Product\Context $context,
        \Extendware\EWBotBlocker\Helper\Config $ewbotConfigHelper,
        array $data = []
    ) {
        $this->ewbotConfigHelper = $ewbotConfigHelper;
        parent::__construct($context, $data);
    }
    /**
     * Form Action Url
     *
     * @return string
     */
    public function getActionUrl()
    {
        $urlPost = $this->getUrl('ewbotblocker/index/validatepost');

        return $urlPost;
    }
    /**
     * Google Captcha Public Key
     *
     * @return string
     */
    public function getSiteKey()
    {
        return $this->ewbotConfigHelper->getPublicKey();
    }
    /**
     * Google Captcha API js
     *
     * @return string
     */
    public function addRecaptachJs()
    {
        return '<script src="https://www.google.com/recaptcha/api.js"></script>';
    }
    /**
     * Redirect Url
     *
     * @return string
     */
    public function getRedirectParamValue()
    {
        return $this->getRequest()->getParam($this->getRedirectParamName());
    }
    /**
     * Url Key For Redirect Url
     *
     * @return string
     */
    public function getRedirectParamName()
    {
        return ActionInterface::PARAM_NAME_URL_ENCODED;
    }
    /**
     * get Captcha Type
     *
     * @return string
     */
    public function getCaptchaType()
    {
        return $this->ewbotConfigHelper->getCaptchaType();
    }

    /**
     * get Captcha Question
     *
     * @return string
     */
    public function getQuestion()
    {
        return $this->ewbotConfigHelper->getQuestion();
    }
}
