<?php

declare(strict_types=1);
namespace Extendware\EWBotBlocker\Controller\Adminhtml\ewbots;

use Magento\Backend\App\Action;

/**
 * Extendware by web-vision GmbH
 *
 * NOTICE OF LICENSE
 *
 * <!--LICENSETEXT-->
 *
 * DISCLAIMER
 *
 * Do not edit or add to this file if you wish to upgrade Magento to newer
 * versions in the future. If you wish to customize Magento for youre
 * needs please refer to https://www.extendware.com/magento-custom-development.html for more information.
 *
 * @category ExtendWare_EWBotBlocker
 *
 * @copyright (c) 2001-2021 Extendware by web-vision GmbH (https://extendware.com/)
 * @license https://support.extendware.com/
 * @affilate https://www.extendware.com/affiliate
 *
 * @author Vaibhav Ahalpara <vaibhav@web-vision.de>
 */
class Save extends Action
{
    /**
     * Save action
     *
     * @return \Magento\Framework\Controller\ResultInterface
     */
    public function execute()
    {
        $data = $this->getRequest()->getPostValue();

        /** @var \Magento\Backend\Model\View\Result\Redirect $resultRedirect */
        $resultRedirect = $this->resultRedirectFactory->create();
        if ($data) {
            $model = $this->_objectManager->create('Extendware\EWBotBlocker\Model\EWbots');

            $id = $this->getRequest()->getParam('bot_id');
            if ($id) {
                $model->load($id);
            }
            $banperiod = $data['expires_at'];
            $date = strtotime("+$banperiod day", time());
            $banDate = date('Y-m-d H:i:s', $date);
            $data['expires_at'] = $banDate;
            $data['created_at'] = date('Y-m-d H:i:s');

            $model->setData($data);

            try {
                $model->save();

                $this->messageManager->addSuccess(__('The EWbots has been saved.'));
                $this->_objectManager->get('Magento\Backend\Model\Session')->setFormData(false);
                if ($this->getRequest()->getParam('back')) {
                    return $resultRedirect->setPath('*/*/edit', ['bot_id' => $model->getId(), '_current' => true]);
                }

                return $resultRedirect->setPath('*/*/');
            } catch (\Magento\Framework\Exception\LocalizedException $e) {
                $this->messageManager->addError($e->getMessage());
            } catch (\RuntimeException $e) {
                $this->messageManager->addError($e->getMessage());
            } catch (\Exception $e) {
                $this->messageManager->addError(__('Ip Address already Exists.'));
            }
            $this->_getSession()->setFormData($data);

            return $resultRedirect->setPath('*/*/edit', ['bot_id' => $this->getRequest()->getParam('bot_id')]);
        }

        return $resultRedirect->setPath('*/*/');
    }
}
