<?php

declare(strict_types=1);
namespace Extendware\EWBotBlocker\Controller\Adminhtml\testasbot;

use Extendware\EWBotBlocker\Helper\Config as configHelper;
use Extendware\EWBotBlocker\Model\EWbotsFactory as botFactory;
use Magento\Backend\App\Action;
use Magento\Framework\HTTP\PhpEnvironment\Request;
use Magento\Store\Model\StoreManagerInterface;
use Extendware\EWBotBlocker\Helper\Data;
use Magento\Framework\Controller\Result\RedirectFactory;

class Index extends \Magento\Backend\App\Action
{
    /**
     * @var Magento\Store\Model\StoreManagerInterface
     */
    protected $_storeManager;
    /**
     * @var Magento\Framework\HTTP\PhpEnvironment\Request
     */
    protected $_serverrequest;
    /**
     * @var Extendware\EWBotBlocker\Helper\Config
     */
    protected $_configHelper;
    /**
     * @var Extendware\EWBotBlocker\Model\EWbotsFactory
     */
    protected $_botFactory;
    /**
     * @var Data
     */
    protected $_helper;
    /**
     * @var RedirectFactory
     */
    protected $resultRedirectFactory;

    /**
     * @param Action\Context $context
     * @param StoreManagerInterface $storeManager
     * @param Request $serverrequest
     * @param configHelper $configHelper
     * @param Data $helper
     * @param botFactory $botFactory
     * @param RedirectFactory $resultRedirectFactory
     */
    public function __construct(
        Action\Context $context,
        StoreManagerInterface $storeManager,
        Request $serverrequest,
        configHelper $configHelper,
        Data $helper,
        botFactory $botFactory,
        RedirectFactory $resultRedirectFactory
    ) {
        parent::__construct($context);
        $this->_storeManager = $storeManager;
        $this->_serverrequest = $serverrequest;
        $this->_configHelper = $configHelper;
        $this->_botFactory = $botFactory;
        $this->_helper = $helper;
        $this->resultRedirectFactory = $resultRedirectFactory;
    }
    /**
     *
     * @return Magento\Backend\Model\View\Result\Redirect
     */
    public function execute()
    {
        $resultRedirect = $this->resultRedirectFactory->create();
        $banDate = $this->_configHelper->getDefaultExpire();
        $status = 'enabled';
        $ipAddress = $this->_serverrequest->getServerValue('REMOTE_ADDR');
        $userAgent = $this->_serverrequest->getServerValue('HTTP_USER_AGENT');

        // Check if IP or User Agent is whitelisted
        if ($this->_helper->isWhitelisted($ipAddress, $userAgent)) {
            return $resultRedirect->setUrl($this->_storeManager->getStore()->getBaseUrl());
        }

        $bot = $this->_botFactory->create();

        try {
            $bot->setStatus($status);
            $bot->setIp($ipAddress);
            $bot->setUserAgent($userAgent);
            $bot->setExpiresAt($banDate);
            $bot->setCreatedAt(date('Y-m-d H:i:s'));
            $bot->save();

            return $resultRedirect->setUrl($this->_storeManager->getStore()->getBaseUrl());
        } catch (\Exception $e) {
            return $resultRedirect->setUrl($this->_storeManager->getStore()->getBaseUrl() . 'welcomb/index/validate');
        }
    }
}
