<?php

declare(strict_types=1);
namespace Extendware\EWBotBlocker\Controller\Index;

use Extendware\EWBotBlocker\Model\EWbotsFactory as botFactory;
use Magento\Framework\App\Action\Action;
use Magento\Framework\App\Action\Context;
use Magento\Framework\App\ResponseInterface;
use Magento\Framework\Controller\Result\RawFactory;
use Magento\Framework\HTTP\PhpEnvironment\Request;
use Magento\Framework\Translate\InlineInterface;
use Magento\Framework\UrlInterface;
use Magento\Framework\View\Element\Template;

/**
 * Extendware by web-vision GmbH
 *
 * NOTICE OF LICENSE
 *
 * <!--LICENSETEXT-->
 *
 * DISCLAIMER
 *
 * Do not edit or add to this file if you wish to upgrade Magento to newer
 * versions in the future. If you wish to customize Magento for youre
 * needs please refer to https://www.extendware.com/magento-custom-development.html for more information.
 *
 * @category ExtendWare_EWBotBlocker
 *
 * @copyright (c) 2001-2021 Extendware by web-vision GmbH (https://extendware.com/)
 * @license https://support.extendware.com/
 * @affilate https://www.extendware.com/affiliate
 *
 * @author Vaibhav Ahalpara <vaibhav@web-vision.de>
 */
class Index extends Action
{
    /**
     * @var Magento\Framework\View\Element\Template
     */
    protected $_template;
    /**
     * @var Magento\Framework\Controller\Result\RawFactory
     */
    protected $_resultRawFactory;
    /**
     * @var Magento\Framework\Translate\InlineInterface
     */
    protected $_translateInline;
    /**
     * @var Magento\Framework\App\ResponseInterface
     */
    protected $_response;
    /**
     * @var Magento\Framework\HTTP\PhpEnvironment\Request
     */
    protected $_serverrequest;
    /**
     * @var Magento\Framework\UrlInterface
     */
    protected $_urlInterface;
    /**
     * @var Extendware\EWBotBlocker\Model\EWbotsFactory
     */
    protected $_botFactory;

    public function __construct(
        Context $context,
        Template $template,
        RawFactory $resultRawFactory,
        InlineInterface $translateInline,
        ResponseInterface $response,
        Request $serverrequest,
        UrlInterface $urlInterface,
        botFactory $botFactory
    ) {
        $this->_template = $template;
        $this->_resultRawFactory = $resultRawFactory;
        $this->_translateInline = $translateInline;
        $this->_response = $response;
        $this->_serverrequest = $serverrequest;
        $this->_urlInterface = $urlInterface;
        $this->_botFactory = $botFactory;

        return parent::__construct($context);
    }
    /**
     *
     * @return Magento\Backend\Model\View\Result\Redirect | Magento\Framework\Controller\Result\RawFactory
     */
    public function execute()
    {
        $this->_response->setHttpResponseCode(403);
        $this->_response->clearBody();
        $this->_response->sendHeaders();

        $bots = $this->_botFactory->create()->load($this->_serverrequest->getServerValue('REMOTE_ADDR'), 'ip');
        if ($bots->getId() && $bots->getStatus() == 'enabled' && $bots->getPermanentlyBlock()) {
            $html = $this->_template->getLayout()->createBlock('Extendware\EWBotBlocker\Block\Index\Index')->setTemplate('Extendware_EWBotBlocker::ewbotblocker_index_index.phtml')->toHtml();
            $this->_translateInline->processResponseBody($html);

            $resultRaw = $this->_resultRawFactory->create();
            $resultRaw->setContents($html);

            return $resultRaw;
        }

        return $this->_redirect($this->_urlInterface->getUrl('/'));
    }
}
