<?php
/**
 * Extendware by web-vision GmbH
 *
 * NOTICE OF LICENSE
 *
 * <!--LICENSETEXT-->
 *
 * DISCLAIMER
 *
 * Do not edit or add to this file if you wish to upgrade Magento to newer
 * versions in the future. If you wish to customize Magento for youre
 * needs please refer to https://www.extendware.com/magento-custom-development.html for more information.
 *
 * @category ExtendWare_EWBotBlocker
 *
 * @copyright (c) 2001-2021 Extendware by web-vision GmbH (https://extendware.com/)
 * @license https://support.extendware.com/
 * @affilate https://www.extendware.com/affiliate
 *
 * @author Vaibhav Ahalpara <vaibhav@web-vision.de>
 */

declare(strict_types=1);
namespace Extendware\EWBotBlocker\Controller\Index;

use Extendware\EWBotBlocker\Helper\Config as configHelper;
use Extendware\EWBotBlocker\Model\EWbotsFactory as botFactory;
use Magento\Backend\App\Action\Context;
use Magento\Framework\App\Action\Action;
use Magento\Framework\HTTP\PhpEnvironment\RemoteAddress;
use Magento\Framework\HTTP\PhpEnvironment\Request;
use Magento\Framework\UrlInterface;
use Psr\Log\LoggerInterface;
use Extendware\EWBotBlocker\Helper\Data;


class Pot extends Action
{
    /**
     * @var Magento\Framework\HTTP\PhpEnvironment\Request
     */
    protected $_serverrequest;
    /**
     * @var Magento\Framework\HTTP\PhpEnvironment\RemoteAddress
     */
    protected $_remoteaddress;
    /**
     * @var Magento\Framework\UrlInterface
     */
    protected $_urlInterface;
    /**
     * @var Psr\Log\LoggerInterface
     */
    protected $_logger;
    /**
     * @var Extendware\EWBotBlocker\Helper\Config
     */
    protected $_configHelper;
    /**
     * @var Extendware\EWBotBlocker\Model\EWbotsFactory
     */
    protected $_botFactory;

    /**
     * @var Data
     */
    protected $_helper;
    
    /**
     * @param Context $context
     * @param Request $serverrequest
     * @param RemoteAddress $remoteaddress
     * @param UrlInterface $urlInterface
     * @param LoggerInterface $logger
     * @param configHelper $configHelper
     * @param botFactory $botFactory
     * @param Data $helper
     */
    public function __construct(
        Context $context,
        Request $serverrequest,
        RemoteAddress $remoteaddress,
        UrlInterface $urlInterface,
        LoggerInterface $logger,
        configHelper $configHelper,
        botFactory $botFactory,
        Data $helper
    ) {
        parent::__construct($context);
        $this->_serverrequest = $serverrequest;
        $this->_remoteaddress = $remoteaddress;
        $this->_urlInterface = $urlInterface;
        $this->_logger = $logger;
        $this->_configHelper = $configHelper;
        $this->_botFactory = $botFactory;
        $this->_helper = $helper;
    }
    /**
     *
     * @return Magento\Backend\Model\View\Result\Redirect
     */
    public function execute()
    {
        if (!$this->_configHelper->IsEnabled()) {
            return;
        }

        $ipAddress = $this->_serverrequest->getServerValue('REMOTE_ADDR');
        $userAgent = $this->_serverrequest->getServerValue('HTTP_USER_AGENT');

        // Check if IP or User Agent is whitelisted
        if ($this->_helper->isWhitelisted($ipAddress, $userAgent)) {
            return $this->_redirect($this->_redirect->getRefererUrl());
        }

        $botsCollection = $this->_botFactory->create()->getCollection()
                        ->addFieldToFilter('ip', $this->_remoteaddress->getRemoteAddress());

        try {
            if ($this->_configHelper->IsOnlyPostEnabled()) {
                if (empty($this->_serverrequest->getServerValue('REQUEST_METHOD')) == false and $this->_serverrequest->getServerValue('REQUEST_METHOD') != 'POST') {
                    return $this->_redirect($this->_redirect->getRefererUrl());
                }
            }

            if (!$botsCollection->getSize()) {
                $status = $this->_configHelper->getDefaultStatus();
                $banDate = $this->_configHelper->getDefaultExpire();

                $bot = $this->_botFactory->create();
                $bot->setStatus($status);
                $bot->setIp($ipAddress);
                $bot->setUserAgent($userAgent);
                $bot->setExpiresAt($banDate);
                $bot->setCreatedAt(date('Y-m-d H:i:s'));
                $bot->save();
            }
        } catch (\Exception $e) {
            $this->_logger->info($e->getMessage());
        }

        return $this->_redirect($this->_urlInterface->getUrl('ewbotblocker/index/validate'));
    }
}
