<?php
/**
 * Extendware by web-vision GmbH
 *
 * NOTICE OF LICENSE
 *
 * <!--LICENSETEXT-->
 *
 * DISCLAIMER
 *
 * Do not edit or add to this file if you wish to upgrade Magento to newer
 * versions in the future. If you wish to customize Magento for youre
 * needs please refer to https://www.extendware.com/magento-custom-development.html for more information.
 *
 * @category ExtendWare_EWBotBlocker
 *
 * @copyright (c) 2001-2021 Extendware by web-vision GmbH (https://extendware.com/)
 * @license https://support.extendware.com/
 * @affilate https://www.extendware.com/affiliate
 *
 * @author Vaibhav Ahalpara <vaibhav@web-vision.de>
 */

declare(strict_types=1);
namespace Extendware\EWBotBlocker\Controller\Index;

use Extendware\EWBotBlocker\Helper\Config as configHelper;
use Extendware\EWBotBlocker\Helper\Data as dataHelper;
use Extendware\EWBotBlocker\Model\EWbotsFactory as botFactory;
use Magento\Backend\App\Action\Context;
use Magento\Framework\App\Action\Action;
use Magento\Store\Model\StoreManagerInterface;
use Psr\Log\LoggerInterface;
use Extendware\EWBotBlocker\Helper\Data;


class Reject extends Action
{
    /**
     * @var Magento\Store\Model\StoreManagerInterface
     */
    protected $storeManager;
    /**
     * @var Extendware\EWBotBlocker\Helper\Config
     */
    protected $configHelper;
    /**
     * @var Extendware\EWBotBlocker\Helper\Data
     */
    protected $dataHelper;
    /**
     * @var Extendware\EWBotBlocker\Model\EWbotsFactory
     */
    protected $botFactory;
    /**
     * @var Psr\Log\LoggerInterface
     */
    protected $_logger;
    /**
     * @var Data
     */
    protected $_helper;


    /**
     * @param Context $context
     * @param StoreManagerInterface $storeManager
     * @param configHelper $configHelper
     * @param Data $dataHelper
     * @param botFactory $botFactory
     * @param LoggerInterface $logger
     * @param Data $helper
     */
    public function __construct(
        Context $context,
        StoreManagerInterface $storeManager,
        configHelper $configHelper,
        dataHelper $dataHelper,
        botFactory $botFactory,
        LoggerInterface $logger,
        Data $helper
    ) {
        parent::__construct($context);
        $this->_storeManager = $storeManager;
        $this->_configHelper = $configHelper;
        $this->_dataHelper = $dataHelper;
        $this->_botFactory = $botFactory;
        $this->_logger = $logger;
        $this->_helper = $helper;
    }
    /**
     *
     * @return Magento\Backend\Model\View\Result\Redirect
     */
    public function execute()
    {
        if ($this->_configHelper->isEnabled() === false) {
            return;
        }

        $ipAddress = $this->_dataHelper->getIpAddress();
        $useragent = $this->_dataHelper->getUserAgent();

        // Check if IP or User Agent is whitelisted
        if ($this->_helper->isWhitelisted($ipAddress, $useragent)) {
            return $this->_redirect($this->_storeManager->getStore()->getBaseUrl());
        }

        try {
            if ($this->_configHelper->isOnlyPostEnabled()) {
                if (isset($_SERVER['REQUEST_METHOD']) and $_SERVER['REQUEST_METHOD'] != 'POST') {
                    return $this->_redirect($this->_storeManager->getStore()->getBaseUrl());
                }
            }

            $banDate = $this->_configHelper->getDefaultExpire();

            $bot = $this->_botFactory->create()->getCollection()->addFieldToFilter('ip', $ipAddress)->getFirstItem();

            if (!$bot->getId()) {
                $bot->setStatus($this->_configHelper->getDefaultStatus());
                $bot->setIp($ipAddress);
                $bot->setUserAgent($useragent);
                $bot->setExpiresAt($banDate);
                $bot->setCreatedAt(date('Y-m-d H:i:s'));
                $bot->save();
            }
        } catch (Exception $e) {
            $this->_logger->info($e->getMessage());
        }

        return $this->_redirect('*/*/validate');
    }
}
