<?php
/**
 * Extendware by web-vision GmbH
 *
 * NOTICE OF LICENSE
 *
 * <!--LICENSETEXT-->
 *
 * DISCLAIMER
 *
 * Do not edit or add to this file if you wish to upgrade Magento to newer
 * versions in the future. If you wish to customize Magento for youre
 * needs please refer to https://www.extendware.com/magento-custom-development.html for more information.
 *
 * @category ExtendWare_EWBotBlocker
 *
 * @copyright (c) 2001-2021 Extendware by web-vision GmbH (https://extendware.com/)
 * @license https://support.extendware.com/
 * @affilate https://www.extendware.com/affiliate
 *
 * @author Vaibhav Ahalpara <vaibhav@web-vision.de>
 */

declare(strict_types=1);
namespace Extendware\EWBotBlocker\Controller\Index;

use Extendware\EWBotBlocker\Helper\Config as configHelper;
use Extendware\EWBotBlocker\Model\EWbotsFactory as botFactory;
use Magento\Backend\App\Action\Context;
use Magento\Framework\App\Action\Action;
use Magento\Framework\HTTP\PhpEnvironment\RemoteAddress;
use Magento\Store\Model\StoreManagerInterface;
use Psr\Log\LoggerInterface;
use Extendware\EWBotBlocker\Helper\Data;
use Magento\Framework\HTTP\PhpEnvironment\Request;

class Validate extends Action
{
    /**
     * @var Magento\Framework\HTTP\PhpEnvironment\RemoteAddress
     */
    protected $_remoteaddress;
    /**
     * @var Magento\Store\Model\StoreManagerInterface
     */
    protected $_storeManager;
    /**
     * @var Psr\Log\LoggerInterface
     */
    protected $_logger;
    /**
     * @var Extendware\EWBotBlocker\Helper\Config
     */
    protected $_configHelper;
    /**
     * @var Extendware\EWBotBlocker\Model\EWbotsFactory
     */
    protected $_botsFactory;

    /**
     * @var Data
     */
    protected $_helper;
    
    /**
     * @var Magento\Framework\HTTP\PhpEnvironment\Request
     */
    protected $_serverrequest;

    /**
     * @param Context $context
     * @param RemoteAddress $remoteaddress
     * @param StoreManagerInterface $storeManager
     * @param LoggerInterface $logger
     * @param configHelper $configHelper
     * @param botFactory $botsFactory
     * @param Data $helper
     * @param Request $serverrequest
     */
    public function __construct(
        Context $context,
        RemoteAddress $remoteaddress,
        StoreManagerInterface $storeManager,
        LoggerInterface $logger,
        configHelper $configHelper,
        botFactory $botsFactory,
        Data $helper,
        Request $serverrequest
    ) {
        parent::__construct($context);
        $this->_remoteaddress = $remoteaddress;
        $this->_configHelper = $configHelper;
        $this->_botsFactory = $botsFactory;
        $this->_storeManager = $storeManager;
        $this->_logger = $logger;
        $this->_helper = $helper;
        $this->_serverrequest = $serverrequest;
    }
    /**
     *
     * @return Magento\Backend\Model\View\Result\Redirect
     */
    public function execute()
    {
        $baseUrl = $this->_storeManager->getStore()->getBaseUrl();
        if (!$this->_configHelper->IsEnabled()) {
            return $this->_redirect($baseUrl);
        }

        $ipAddress = $this->_serverrequest->getServerValue('REMOTE_ADDR');
        $userAgent = $this->_serverrequest->getServerValue('HTTP_USER_AGENT');

        // Check if IP or User Agent is whitelisted
        if ($this->_helper->isWhitelisted($ipAddress, $userAgent)) {
            return $this->_redirect($baseUrl);
        }

        $bot = $this->_botsFactory->create()->getCollection()
                        ->addFieldToFilter('ip', $this->_remoteaddress->getRemoteAddress())
                        ->getFirstItem();
        if ($bot->getBotId()) {
            try {
                $bot->setLastSeenAt(date('Y-m-d H:i:s'));
                $bot->setTotalVisits($bot->getTotalVisits() + 1);
                $bot->save();
            } catch (\Exception $e) {
                $this->_logger->info($e->getMessage());
            }
            $this->_view->loadLayout();
            $this->_view->getLayout()->initMessages();
            $this->_view->renderLayout();
        } else {
            return $this->_redirect($baseUrl);
        }
    }
}
