<?php

declare(strict_types=1);
namespace Extendware\EWBotBlocker\Controller\Index;

use Extendware\EWBotBlocker\Helper\Config as configHelper;
use Extendware\EWBotBlocker\Model\EWbotsFactory as botFactory;
use Magento\Captcha\Helper\Data as captchaHelper;
use Magento\Captcha\Observer\CaptchaStringResolver;
use Magento\Framework\App\Action\Action;
use Magento\Framework\App\Action\Context;
use Magento\Framework\App\ActionInterface;
use Magento\Framework\HTTP\PhpEnvironment\Request;
use Magento\Framework\Url\DecoderInterface;
use Magento\Store\Model\StoreManagerInterface;
use Psr\Log\LoggerInterface;

/**
 * Extendware by web-vision GmbH
 *
 * NOTICE OF LICENSE
 *
 * <!--LICENSETEXT-->
 *
 * DISCLAIMER
 *
 * Do not edit or add to this file if you wish to upgrade Magento to newer
 * versions in the future. If you wish to customize Magento for youre
 * needs please refer to https://www.extendware.com/magento-custom-development.html for more information.
 *
 * @category ExtendWare_EWBotBlocker
 *
 * @copyright (c) 2001-2021 Extendware by web-vision GmbH (https://extendware.com/)
 * @license https://support.extendware.com/
 * @affilate https://www.extendware.com/affiliate
 *
 * @author Vaibhav Ahalpara <vaibhav@web-vision.de>
 */
class Validatepost extends Action
{
    /**
     * @var Magento\Framework\HTTP\PhpEnvironment\Request
     */
    protected $_serverrequest;
    /**
     * @var Magento\Store\Model\StoreManagerInterface
     */
    protected $_storeManager;
    /**
     * @var Magento\Framework\Url\DecoderInterface
     */
    protected $_decode;
    /**
     * @var Psr\Log\LoggerInterface
     */
    protected $_logger;
    /**
     * @var Magento\Captcha\Helper\Data
     */
    protected $_captchaHelper;
    /**
     * @var Magento\Captcha\Observer\CaptchaStringResolver
     */
    protected $_captchaStringResolver;
    /**
     * @var Extendware\EWBotBlocker\Helper\Config
     */
    protected $_configHelper;
    /**
     * @var Extendware\EWBotBlocker\Model\EWbotsFactory
     */
    protected $_botsFactory;
    /**
     * @var string
     */
    protected static $_siteVerifyUrl = 'https://www.google.com/recaptcha/api/siteverify?';
    /**
     * @var string
     */
    protected $_secret;
    /**
     * @var string
     */
    protected static $_version = 'php_1.0';

    /**
     *
     * @param  \Magento\Framework\App\Action\Context           $context
     * @param  \Magento\Framework\HTTP\PhpEnvironment\Request  $serverrequest
     * @param  \Magento\Store\Model\StoreManagerInterface      $storeManager
     * @param  \Magento\Framework\Url\DecoderInterface         $decode
     * @param  \Psr\Log\LoggerInterface                        $logger
     * @param  \Magento\Captcha\Helper\Data                    $captchaHelper
     * @param  \Magento\Captcha\Observer\CaptchaStringResolver $_captchaStringResolver
     * @param  \Extendware\EWBotBlocker\Helper\Config          $configHelper
     * @param  \Extendware\EWBotBlocker\Model\EWbotsFactory    $botsFactory
     */
    public function __construct(
        Context $context,
        Request $serverrequest,
        StoreManagerInterface $storeManager,
        DecoderInterface $decode,
        LoggerInterface $logger,
        captchaHelper $captchaHelper,
        CaptchaStringResolver $captchaStringResolver,
        configHelper $configHelper,
        botFactory $botsFactory
    ) {
        parent::__construct($context);
        $this->_serverrequest = $serverrequest;
        $this->_storeManager = $storeManager;
        $this->_decode = $decode;
        $this->_logger = $logger;
        $this->_captchaHelper = $captchaHelper;
        $this->_captchaStringResolver = $captchaStringResolver;
        $this->_configHelper = $configHelper;
        $this->_botsFactory = $botsFactory;
    }
    /**
     *
     * @return Magento\Backend\Model\View\Result\Redirect
     */
    public function execute()
    {
        $baseUrl = $this->_storeManager->getStore()->getBaseUrl();
        if (!$this->_configHelper->IsEnabled()) {
            return $this->resultRedirectFactory->create()->setUrl($baseUrl);
        }

        $redirectUrl = $this->getRequest()->getParam(ActionInterface::PARAM_NAME_URL_ENCODED);
        $answers = ['success' => false];
        if ($this->_configHelper->getCaptchaType() == configHelper::TYPE_MAGENTO) {
            $formId = 'verify_bot_form';
            $captcha = $this->_captchaHelper->getCaptcha($formId);
            $answers['success'] = $captcha->isCorrect($this->_captchaStringResolver->resolve($this->getRequest(), $formId));
        } elseif ($this->_configHelper->getCaptchaType() == configHelper::TYPE_STATIC) {
            if (strtolower($this->_configHelper->getAnswer()) == strtolower($this->getRequest()->getParam('answer'))) {
                $answers['success'] = true;
            }
        } else {
            $this->_secret = $this->_configHelper->getSecretKey();
            $captcha = $this->getRequest()->getParam('g-recaptcha-response');
            $response = null;
            $path = self::$_siteVerifyUrl;
            $dataCaptcha = [
                               'secret' => $this->_secret,
                               'remoteip' => $this->_serverrequest->getServerValue('REMOTE_ADDR'),
                               'v' => self::$_version,
                               'response' => $captcha,
                        ];
            $req = '';
            foreach ($dataCaptcha as $key => $value) {
                $req .= $key . '=' . urlencode(stripslashes($value ?? '')) . '&';
            }
            $req = substr($req, 0, strlen($req) - 1);
            $response = file_get_contents($path . $req);
            $answers = json_decode($response, true);
        }
        if (isset($answers['success']) && $answers['success'] == true) {
            $botsCollection = $this->_botsFactory->create()->getCollection()
                        ->addFieldToFilter('ip', $this->_serverrequest->getServerValue('REMOTE_ADDR'));
            foreach ($botsCollection as $bot) {
                try {
                    $bot->delete();
                } catch (\Exception $e) {
                    $this->_logger->info($e->getMessage());
                }
            }
            $this->messageManager->addSuccessMessage(__('We have identified you a human, you are free to access the site.'));
            $decodeUrl = $this->_decode->decode($redirectUrl);
            if ($redirectUrl && $decodeUrl) {
                return $this->resultRedirectFactory->create()->setUrl($decodeUrl);
            }

            return $this->resultRedirectFactory->create()->setUrl($baseUrl);
        }
        $this->messageManager->addErrorMessage(__('Captcha is not correct, please try again.'));

        return $this->resultRedirectFactory->create()->setUrl($this->_redirect->getRefererUrl());
    }
}
