<?php

declare(strict_types=1);

namespace Extendware\EWBotBlocker\Controller;

use Extendware\EWBotBlocker\Helper\Data as dataHelper;
use Magento\Framework\App\ActionInterface;
use Magento\Framework\App\RequestInterface;
use Magento\Framework\App\RouterInterface;

/**
 * Extendware by web-vision GmbH
 *
 * NOTICE OF LICENSE
 *
 * <!--LICENSETEXT-->
 *
 * DISCLAIMER
 *
 * Do not edit or add to this file if you wish to upgrade Magento to newer
 * versions in the future. If you wish to customize Magento for youre
 * needs please refer to https://www.extendware.com/magento-custom-development.html for more information.
 *
 * @category ExtendWare_EWBotBlocker
 *
 * @copyright (c) 2001-2021 Extendware by web-vision GmbH (https://extendware.com/)
 * @license https://support.extendware.com/
 * @affilate https://www.extendware.com/affiliate
 *
 * @author Vaibhav Ahalpara <vaibhav@web-vision.de>
 */
class Router implements RouterInterface
{
    /**
     * @var dataHelper
     */
    protected dataHelper $_dataHelper;

    /**
     *
     * @param  \Extendware\EWBotBlocker\Helper\Data $dataHelper
     */
    public function __construct(
        dataHelper $dataHelper
    ) {
        $this->_dataHelper = $dataHelper;
    }
    /**
     *
     * @param  \Magento\Framework\App\RequestInterface     $request
     *
     * @return \Magento\Framework\App\ActionInterface|null
     */
    public function match(RequestInterface $request): ?ActionInterface
    {
        $identifier = trim($request->getPathInfo(), '/');
        $params = $request->getParams();
        $postHoneyPot = false;
        $foundStopWord = false;
        if (count($params)) {
            $stopWords = $this->_dataHelper->getStopWordForForm($identifier);
            foreach ($params as $key => $value) {
                if ($foundStopWord) {
                    break;
                }
                if ($this->_dataHelper->isHoneypotPath($key) === true && $value) {
                    $postHoneyPot = true;
                    break;
                }
                foreach ($stopWords as $word) {
                    if (is_array($value)) {
                        $value = json_encode($value);
                    }
                    if (strpos($value, $word) !== false) {
                        $foundStopWord = true;
                        break;
                    }
                }
            }
        }
        if ($this->_dataHelper->isHoneypotPath($identifier) === true || $postHoneyPot || $foundStopWord) {
            $request->setModuleName('welcomb');
            $request->setControllerName('index');
            $request->setActionName('reject');

            $request->setAlias(\Magento\Framework\Url::REWRITE_REQUEST_PATH_ALIAS, $identifier);

            return null;
        }

        return null;
    }
}
