<?php

namespace Extendware\EWBotBlocker\Helper;

use Extendware\Core\Model\ExtendwareModule;
use Magento\Framework\App\Config\ScopeConfigInterface;
use Magento\Framework\App\Helper\AbstractHelper;
use Magento\Store\Model\ScopeInterface;

class Config extends AbstractHelper
{
    /**
     * @var Magento\Framework\App\Config\ScopeConfigInterface
     */
    protected $_scopeConfig;
    /**
     * @var ExtendwareModule
     */
    protected $_extendwareModule;

    /**
    * Search Block Type Keyword
    */
    public const TYPE_KEYWORD = 0;

    /**
    * Search Block Type Keyword
    */
    public const TYPE_REGEXP = 1;

    /**
    * Captcha Type Magento
    */
    public const TYPE_MAGENTO = 'magento';

    /**
    * Captcha Type Google
    */
    public const TYPE_GOOGLE = 'google';

    /**
    * Captcha Type Static
    */
    public const TYPE_STATIC = 'static';

    /**
    * Bot Block Enable
    */
    public const XML_PATH_GENERAL_ENABLE = 'ewbotblocker/general/enable';

    /**
    * Bot Block Default Status
    */
    public const XML_PATH_GENERAL_DEFAULTSTATUS = 'ewbotblocker/general/defaultstatus';

    /**
    * Honeypot Form Detection
    */
    public const XML_PATH_GENERAL_HONEYPOT_FORM_ENABLED = 'ewbotblocker/general/honeypot_form_enabled';

    /**
    * Honeypot Link Detection
    */
    public const XML_PATH_GENERAL_HONEYPOT_LINK_ENABLED = 'ewbotblocker/general/honeypot_link_enabled';

    /**
    * Form Protection
    */
    public const XML_PATH_GENERAL_FROM_PROTECTION_ENABLED = 'ewbotblocker/general/form_protection_enabled';

    /**
    * Form Protection Honeypotted Urls
    */
    public const XML_PATH_GENERAL_FROM_PROTECTION_URL_ENABLED = 'ewbotblocker/general/form_protection_honeypotted_urls_enabled';

    /**
    * Form Protection Honeypotted Urls on checkout page
    */
    public const XML_PATH_GENERAL_FROM_PROTECTION_CHECKOUT_PAGE = 'ewbotblocker/general/disable_on_checkout_page';

    /**
    * Salt
    */
    public const XML_PATH_ADVANCED_SALT = 'ewbotblocker/advanced/salt';

    /**
    * Only Post
    */
    public const XML_PATH_ADVANCED_ONLY_POST_ENABLED = 'ewbotblocker/advanced/only_post_enabled';

    /**
    * Verification Cookie
    */
    public const XML_PATH_ADVANCED_VERIFICATION_COOKIE_ENABLED = 'ewbotblocker/advanced/is_verification_cookie_enabled';

    /**
    * Path Prefix
    */
    public const XML_PATH_ADVANCED_PATH_PREFIX = 'ewbotblocker/advanced/path_prefix';

    /**
    * Ban Length (days)
    */
    public const XML_PATH_ADVANCED_DAYS_TO_EXPIRE = 'ewbotblocker/advanced/days_to_expire';

    /**
    * Stop Word for forms
    */
    public const XML_PATH_ADVANCED_STOP_WORD_FOR_FROM = 'ewbotblocker/advanced/stop_word_for_form';

    /**
    * Use same stop word for all the form
    */
    public const XML_PATH_ADVANCED_USE_SAME_WORD_FOR_ALL_FORM = 'ewbotblocker/advanced/use_same_word_for_all_form';

    /**
    * Stop Word For All Forms
    */
    public const XML_PATH_ADVANCED_STOP_WORD_FOR_ALL_FORM = 'ewbotblocker/advanced/stop_word_for_all_form';

    /**
    * Stop word for selected form
    */
    public const XML_PATH_ADVANCED_STOP_WORD = 'ewbotblocker/advanced/stop_word';

    /**
    * Form Protection Excluded Forms
    */
    public const XML_PATH_ADVANCED_EXCLUDES_FROM_IDS = 'ewbotblocker/advanced/excluded_form_ids';

    /**
    * URL Regular Expressions
    */
    public const XML_PATH_ADVANCED_URL_FILTERS = 'ewbotblocker/advanced/url_filters';

    /**
    * Honeypot Paths RegExp
    */
    public const XML_PATH_ADVANCED_HONEYPOT_PATHS = 'ewbotblocker/advanced/honeypot_paths';

    /**
    * Captcha Type
    */
    public const XML_PATH_ADVANCED_CAPTCHA_TYPE = 'ewbotblocker/advanced/captcha_type';

    /**
    * Recaptcha Public Key
    */
    public const XML_PATH_ADVANCED_PUBLICKEY = 'ewbotblocker/advanced/publickey';

    /**
    * Recaptcha Secretkey Key
    */
    public const XML_PATH_ADVANCED_SECRETKEY = 'ewbotblocker/advanced/secretkey';

    /**
    * Captcha question for frontend user
    */
    public const XML_PATH_ADVANCED_QUESTION = 'ewbotblocker/advanced/question';

    /**
    * Captcha correct answer of the question
    */
    public const XML_PATH_ADVANCED_ANSWER = 'ewbotblocker/advanced/answer';

    /**
    * IP Mode
    */
    public const XML_PATH_ADVANCED_IP_MODE = 'ewbotblocker/advanced/ip_mode';


    /**
    * Ban Search Keyword Enable
    */
    public const XML_PATH_SEARCHBOT_ENABLE = 'ewbotblocker/searchbot/enable';

    /**
    * Ban Keywords
    */
    public const XML_PATH_SEARCHBOT_KEYWORD = 'ewbotblocker/searchbot/keyword';

    /**
    * Permanently Ban From website
    */
    public const XML_PATH_SEARCHBOT_BLOCK = 'ewbotblocker/searchbot/block';

    /**
    * Ban keyword limit
    */
    public const XML_PATH_SEARCHBOT_TRY = 'ewbotblocker/searchbot/try';

    /**
    * Search Ban Contact Email
    */
    public const XML_PATH_SEARCHBOT_EMAIL = 'ewbotblocker/searchbot/email';

    /**
    * System Admin Store Email Address
    */
    public const XML_PATH_STORE_EMAIL = 'trans_email/ident_general/email';

    /**
     * Whitelisted IP Ranges
     */
    public const XML_PATH_WHITELIST_IPS = 'ewbotblocker/whitelist/whitelist_ips';

    /**
     * Whitelisted User Agents
     */
    public const XML_PATH_WHITELIST_USER_AGENT = 'ewbotblocker/whitelist/whitelist_user_agents';

    /**
    * System Admin Store Email Address
    */
    public const MODULE_NAME = 'Extendware_EWBotBlocker';

    /**
     *
     * @param  \Magento\Framework\App\Config\ScopeConfigInterface $scopeConfig
     * @param  \Extendware\Core\Model\ExtendwareModule $extendwareModule
     */
    public function __construct(
        ScopeConfigInterface $scopeConfig,
        ExtendwareModule $extendwareModule
    ) {
        $this->_scopeConfig = $scopeConfig;
        $this->_extendwareModule = $extendwareModule;
    }
    /**
     *
     * @param  string $tabGrpSectionField
     *
     * @return string|array|int|null
     */
    public function getConfig($tabGrpSectionField)
    {
        return $this->_scopeConfig->getValue(
            $tabGrpSectionField,
            ScopeInterface::SCOPE_STORE
        );
    }
    /**
     *
     * @return string|null
     */
    public function IsEnabled()
    {
        $module = $this->_extendwareModule->load(self::MODULE_NAME, \Extendware\Core\Api\Data\ExtendwareModuleInterface::MODULE_NAME);
        if ($module->getModuleActive()) {
            return $this->getConfig(self::XML_PATH_GENERAL_ENABLE);
        }

        return false;
    }
    /**
     *
     * @return string|null
     */
    public function getDefaultStatus()
    {
        if ($this->getConfig(self::XML_PATH_GENERAL_DEFAULTSTATUS)) {
            return 'disabled';
        }

        return 'enabled';
    }
    /**
     *
     * @return string|null
     */
    public function IsHoneypotFormEnabled()
    {
        return $this->getConfig(self::XML_PATH_GENERAL_HONEYPOT_FORM_ENABLED);
    }
    /**
     *
     * @return string|null
     */
    public function IsHoneypotLinkEnabled()
    {
        return $this->getConfig(self::XML_PATH_GENERAL_HONEYPOT_LINK_ENABLED);
    }
    /**
     *
     * @return string|null
     */
    public function IsFormProtectionEnabled()
    {
        return $this->getConfig(self::XML_PATH_GENERAL_FROM_PROTECTION_ENABLED);
    }
    /**
     *
     * @return string|null
     */
    public function IsFormProtectionDisableOnCheckout()
    {
        return $this->getConfig(self::XML_PATH_GENERAL_FROM_PROTECTION_CHECKOUT_PAGE);
    }
    /**
     *
     * @return string|null
     */
    public function IsFormProtectionHoneypottedUrlsEnabled()
    {
        return $this->getConfig(self::XML_PATH_GENERAL_FROM_PROTECTION_URL_ENABLED);
    }
    /**
     *
     * @return string|null
     */
    public function getSalt()
    {
        return $this->getConfig(self::XML_PATH_ADVANCED_SALT);
    }
    /**
     *
     * @return string|null
     */
    public function IsOnlyPostEnabled()
    {
        return $this->getConfig(self::XML_PATH_ADVANCED_ONLY_POST_ENABLED);
    }
    /**
     *
     * @return string|null
     */
    public function IsVerificationCookieEnabled()
    {
        return $this->getConfig(self::XML_PATH_ADVANCED_VERIFICATION_COOKIE_ENABLED);
    }
    /**
     *
     * @return string|null
     */
    public function getPathPrefix()
    {
        return $this->getConfig(self::XML_PATH_ADVANCED_PATH_PREFIX);
    }
    /**
     *
     * @return string|null
     */
    public function getDaysToExpire()
    {
        return $this->getConfig(self::XML_PATH_ADVANCED_DAYS_TO_EXPIRE);
    }
    /**
     *
     * @return string|null
     */
    public function getStopWordForForms()
    {
        return $this->getConfig(self::XML_PATH_ADVANCED_STOP_WORD_FOR_FROM);
    }
    /**
     *
     * @return string|null
     */
    public function getUseSameStopWordForAllTheForm()
    {
        return $this->getConfig(self::XML_PATH_ADVANCED_USE_SAME_WORD_FOR_ALL_FORM);
    }
    /**
     *
     * @return string|null
     */
    public function getStopWordForAllForms()
    {
        return $this->getConfig(self::XML_PATH_ADVANCED_STOP_WORD_FOR_ALL_FORM);
    }
    /**
     *
     * @return string|null
     */
    public function getStopWordForSelectedForm()
    {
        $value = $this->getConfig(self::XML_PATH_ADVANCED_STOP_WORD);
        if ($value) {
            $value = json_decode($value, true);
        }
        return $value;
    }
    /**
     *
     * @return array|null
     */
    public function getExcludedFormIds()
    {
        $value = $this->getConfig(self::XML_PATH_ADVANCED_EXCLUDES_FROM_IDS);
        if ($value) {
            $value = json_decode($value, true);
        }

        return $value;
    }
    /**
     *
     * @return array|null
     */
    public function getRunnableUrlFilters()
    {
        $value = $this->getConfig(self::XML_PATH_ADVANCED_URL_FILTERS);
        if ($value) {
            $value = json_decode($value, true);
        }

        return $value;
    }
    /**
     *
     * @return array|null
     */
    public function getHoneypotPaths()
    {
        $value = $this->getConfig(self::XML_PATH_ADVANCED_HONEYPOT_PATHS);
        if ($value) {
            $value = json_decode($value, true);
        }

        return $value;
    }
    /**
     *
     * @return string|null
     */
    public function getIpMode()
    {
        return $this->getConfig(self::XML_PATH_ADVANCED_IP_MODE);
    }
    /**
     *
     * @return string|null
     */
    public function getCaptchaType()
    {
        return $this->getConfig(self::XML_PATH_ADVANCED_CAPTCHA_TYPE);
    }
    /**
     *
     * @return string|null
     */
    public function getPublicKey()
    {
        return $this->getConfig(self::XML_PATH_ADVANCED_PUBLICKEY);
    }
    /**
     *
     * @return string|null
     */
    public function getSecretKey()
    {
        return $this->getConfig(self::XML_PATH_ADVANCED_SECRETKEY);
    }
    /**
     *
     * @return string|null
     */
    public function getQuestion()
    {
        return $this->getConfig(self::XML_PATH_ADVANCED_QUESTION);
    }
    /**
     *
     * @return string|null
     */
    public function getAnswer()
    {
        return $this->getConfig(self::XML_PATH_ADVANCED_ANSWER);
    }
    /**
     *
     * @return string|null
     */
    public function getSearchBotEnable()
    {
        return $this->getConfig(self::XML_PATH_SEARCHBOT_ENABLE);
    }
    /**
     *
     * @return array|null
     */
    public function getSearchBotKeyword()
    {
        $value = $this->getConfig(self::XML_PATH_SEARCHBOT_KEYWORD);
        if ($value) {
            $value = json_decode($value, true);
        }

        return $value;
    }
    /**
     *
     * @return string|null
     */
    public function getSearchBotBlock()
    {
        return $this->getConfig(self::XML_PATH_SEARCHBOT_BLOCK);
    }
    /**
     *
     * @return string|null
     */
    public function getSearchBotTry()
    {
        return $this->getConfig(self::XML_PATH_SEARCHBOT_TRY);
    }
    /**
     *
     * @return string|null
     */
    public function getContactEmail()
    {
        $email = $this->getConfig(self::XML_PATH_SEARCHBOT_EMAIL);
        if (!$email) {
            $email = $this->getConfig(self::XML_PATH_STORE_EMAIL);
        }

        return $email;
    }
    /**
     *
     * @return string|null
     */
    public function getDefaultExpire()
    {
        $banPeriod = $this->getDaysToExpire();
        if (!$banPeriod) {
            $banPeriod = 30;
        }
        $date = strtotime("+$banPeriod day", time());
        $banDate = date('Y-m-d H:i:s', $date);

        return $banDate;
    }

    /**
     * Retrieve the list of whitelisted IPs from the configuration.
     *
     * @return array
     */
    public function getWhitelistedIps()
    {
        $ips = $this->getConfig(self::XML_PATH_WHITELIST_IPS);
        return $ips ? explode("\n", $ips) : [];
    }

    /**
     * Retrieve the list of whitelisted user agents from the configuration.
     *
     * @return array
     */
    public function getWhitelistedUserAgents()
    {
        $userAgents = $this->getConfig(self::XML_PATH_WHITELIST_USER_AGENT);
        return $userAgents ? explode("\n", $userAgents) : [];
    }
}
