<?php

declare(strict_types=1);
namespace Extendware\EWBotBlocker\Observer;

use Extendware\EWBotBlocker\Helper\Config as configHelper;
use Extendware\EWBotBlocker\Helper\Data as dataHelper;
use Extendware\EWBotBlocker\Model\EWbotsFactory as botFactory;
use Magento\Framework\App\ActionInterface;
use Magento\Framework\App\Request\Http;
use Magento\Framework\Event\ObserverInterface;
use Magento\Framework\Url\EncoderInterface;
use Magento\Framework\UrlInterface;
use Magento\Store\Model\StoreManagerInterface;

/**
 * Extendware by web-vision GmbH
 *
 * NOTICE OF LICENSE
 *
 * <!--LICENSETEXT-->
 *
 * DISCLAIMER
 *
 * Do not edit or add to this file if you wish to upgrade Magento to newer
 * versions in the future. If you wish to customize Magento for youre
 * needs please refer to https://www.extendware.com/magento-custom-development.html for more information.
 *
 * @category ExtendWare_EWBotBlocker
 *
 * @copyright (c) 2001-2021 Extendware by web-vision GmbH (https://extendware.com/)
 * @license https://support.extendware.com/
 * @affilate https://www.extendware.com/affiliate
 *
 * @author Vaibhav Ahalpara <vaibhav@web-vision.de>
 */
class FrontInitBefore implements ObserverInterface
{
    /**
     * @var Magento\Framework\App\Request\Http
     */
    protected $_request;
    /**
     * @var Magento\Store\Model\StoreManagerInterface
     */
    protected $_storeManager;
    /**
     * @var Magento\Framework\Url\EncoderInterface
     */
    protected $_encoder;
    /**
     * @var Extnendware\EWBotBlocker\Model\EWbotsFactory
     */
    protected $_botFactory;
    /**
     * @var Extedware\EWBotBlocker\Helper\Config
     */
    protected $_configHelper;
    /**
     * @var Extendware\EWBotBlocker\Helper\Data
     */
    protected $_dataHelper;
    /**
     *
     * @param  \Magento\Framework\App\Request\Http          $request
     * @param  \Magento\Store\Model\StoreManagerInterface   $storeManager
     * @param  \Magento\Framework\Url\EncoderInterface      $encoder
     * @param  \Extnendware\EWBotBlocker\Model\EWbotsFactory $botFactory
     * @param  \Extedware\EWBotBlocker\Helper\Config       $configHelper
     * @param  \Extendware\EWBotBlocker\Helper\Data         $dataHelper
     */
    public function __construct(
        Http $request,
        StoreManagerInterface $storeManager,
        EncoderInterface $encoder,
        botFactory $botFactory,
        configHelper $configHelper,
        dataHelper $dataHelper
    ) {
        $this->_request = $request;
        $this->_storeManager = $storeManager;
        $this->_encoder = $encoder;
        $this->_botFactory = $botFactory;
        $this->_configHelper = $configHelper;
        $this->_dataHelper = $dataHelper;
    }
    /**
     *
     * @param  \Magento\Framework\Event\Observer $observer
     *
     * @return void
     */
    public function execute(\Magento\Framework\Event\Observer $observer)
    {
        if (!$this->_configHelper->isEnabled()) {
            return;
        }
        if ($this->_dataHelper->isVerificationCookieValid()) {
            return;
        }
        $uri = ltrim($this->_request->getRequestUri(), '/');
        if (strpos($uri, 'welcomb/') !== false) {
            return;
        }
        if ($this->_dataHelper->uriMatchesDisqualifiers()) {
            return;
        }

        $collection = $this->_botFactory->create()->getCollection();
        $collection->addFieldToFilter('status', 'enabled');
        $collection->addFieldToFilter('ip', $this->_dataHelper->getIpAddress());
        $collection->addFieldToFilter('expires_at', ['gteq' => date('Y-m-d H:i:s')]);
        $bot = $collection->getFirstItem();

        if ($bot->getId() > 0) {
            $baseUrl = ($this->_request->isSecure() ? 'https://' : 'http://') . $this->_request->getHttpHost();
            $currentUrl = $baseUrl . $this->_request->getRequestUri();
            $url = $this->_storeManager->getStore()->getBaseUrl(UrlInterface::URL_TYPE_LINK, $this->_request->isSecure()) . 'welcomb/index/validate/?' . ActionInterface::PARAM_NAME_URL_ENCODED . '=' . $this->_encoder->encode($currentUrl);
            $protocol = ($_SERVER['SERVER_PROTOCOL'] == 'HTTP/1.1' ? 'HTTP/1.1' : 'HTTP/1.0');
            header(sprintf('Location: %s', $url));
            return;
        }

        if (headers_sent() === false) {
            $this->_dataHelper->sendVerificationCookie();
        }
    }
}
