<?php

declare(strict_types=1);

namespace Extendware\EWBotBlocker\Observer;

use Extendware\EWBotBlocker\Helper\Config as configHelper;
use Extendware\EWBotBlocker\Helper\Data as dataHelper;
use Extendware\EWBotBlocker\Model\EWbotsFactory as botFactory;
use Extendware\EWBotBlocker\Model\EWsearchFactory as searchFactory;
use Magento\Framework\App\Request\Http;
use Magento\Framework\Event\ObserverInterface;
use Magento\Framework\HTTP\PhpEnvironment\Request;
use Magento\Framework\UrlInterface;
use Extendware\EWBotBlocker\Helper\Data;
use Magento\Framework\Data\Form\FormKey;

/**
 * Extendware by web-vision GmbH
 *
 * NOTICE OF LICENSE
 *
 * <!--LICENSETEXT-->
 *
 * DISCLAIMER
 *
 * Do not edit or add to this file if you wish to upgrade Magento to newer
 * versions in the future. If you wish to customize Magento for youre
 * needs please refer to https://www.extendware.com/magento-custom-development.html for more information.
 *
 * @category ExtendWare_EWBotBlocker
 *
 * @copyright (c) 2001-2021 Extendware by web-vision GmbH (https://extendware.com/)
 * @license https://support.extendware.com/
 * @affilate https://www.extendware.com/affiliate
 *
 * @author Vaibhav Ahalpara <vaibhav@web-vision.de>
 */
class Sendresponsebefore implements ObserverInterface
{
    /**
     * @var Magento\Framework\UrlInterface
     */
    protected $_urlInterface;
    /**
     * @var Magento\Framework\HTTP\PhpEnvironment\Request
     */
    protected $_serverrequest;
    /**
     * @var Magento\Framework\App\Request\Http
     */
    protected $_request;
    /**
     * @var Extendware\EWBotBlocker\Model\EWbotsFactory
     */
    protected $_botFactory;
    /**
     * @var Extendware\EWBotBlocker\Helper\Config
     */
    protected $_configHelper;
    /**
     * @var Extendware\EWBotBlocker\Helper\Data
     */
    protected $_dataHelper;
    /**
     * @var Extendware\EWBotBlocker\Model\EWsearchFactory
     */
    protected $_searchFactory;
    /**
     * @var FormKey
     */
    protected $_formKey;
    /**
     * @var Data
     */
    protected $_helper;

    /**
     * @param UrlInterface $urlInterface
     * @param Request $serverrequest
     * @param Http $request
     * @param botFactory $botFactory
     * @param configHelper $configHelper
     * @param Data $dataHelper
     * @param searchFactory $searchFactory
     * @param Data $helper
     * @param FormKey $formKey
     */
    public function __construct(
        UrlInterface  $urlInterface,
        Request       $serverrequest,
        Http          $request,
        botFactory    $botFactory,
        configHelper  $configHelper,
        dataHelper    $dataHelper,
        searchFactory $searchFactory,
        Data          $helper,
        FormKey       $formKey
    )
    {
        $this->_urlInterface = $urlInterface;
        $this->_serverrequest = $serverrequest;
        $this->_request = $request;
        $this->_botFactory = $botFactory;
        $this->_configHelper = $configHelper;
        $this->_dataHelper = $dataHelper;
        $this->_searchFactory = $searchFactory;
        $this->_formKey = $formKey;
        $this->_helper = $helper;
    }

    /**
     *
     * @param \Magento\Framework\Event\Observer $observer
     *
     * @return void
     */
    public function execute(\Magento\Framework\Event\Observer $observer)
    {
        $uri = ltrim($this->_urlInterface->getCurrentUrl(), '/');
        $searchBan = $this->_configHelper->getSearchBotEnable();
        //block search keyword start
        if ($searchBan && $uri !== null && strpos($uri, 'catalogsearch/result') !== false) {
            $query = $this->_request->getParam('q');
            $keywords = $this->_configHelper->getSearchBotKeyword();
            $allowedTry = $this->_configHelper->getSearchBotTry();
            $blockIp = $this->_configHelper->getSearchBotBlock();
            $banDate = $this->_configHelper->getDefaultExpire();
            if ($keywords) {
                foreach ($keywords as $keyword) {
                    if (($keyword['type'] == \Extendware\EWBotBlocker\Helper\Config::TYPE_KEYWORD &&
                            ($query !== null && strpos($query, $keyword['keyword']) !== false)) ||
                        ($keyword['type'] == \Extendware\EWBotBlocker\Helper\Config::TYPE_REGEXP &&
                            preg_match($keyword['keyword'], $query))
                    ) {
                        $ipAddress = $this->_serverrequest->getServerValue('REMOTE_ADDR');
                        $userAgent = $this->_serverrequest->getServerValue('HTTP_USER_AGENT');
                        // Check if IP or User Agent is whitelisted
                        if ($this->_helper->isWhitelisted($ipAddress, $userAgent)) {
                            return;
                        }
                        $search = $this->_searchFactory->create();
                        $search->load($this->_serverrequest->getServerValue('REMOTE_ADDR'), 'ip');
                        if ($search->getId()) {
                            $totalTry = $search->getTotalTry() + 1;
                            if ($blockIp && $allowedTry <= $totalTry) {
                                $bots = $this->_botFactory->create();
                                $bots->load($this->_serverrequest->getServerValue('REMOTE_ADDR'), 'ip');
                                if ($bots->getId()) {
                                    $bots->setStatus('enabled');
                                    $bots->setPermanentlyBlock(1);
                                    $bots->setExpiresAt($banDate);
                                } else {
                                    $data['ip'] = $this->_serverrequest->getServerValue('REMOTE_ADDR');
                                    $data['user_agent'] = $this->_serverrequest->getServerValue('HTTP_USER_AGENT');
                                    $data['updated_at'] = date('Y-m-d H:i:s');
                                    $data['created_at'] = date('Y-m-d H:i:s');
                                    $data['status'] = 'enabled';
                                    $data['total_visits'] = 1;
                                    $data['expires_at'] = $banDate;
                                    $data['permanently_block'] = 1;
                                    $bots->setData($data);
                                }
                                $bots->save();
                                $redirectUrl = $this->_urlInterface->getUrl('ewbotblocker');
                                $observer->getResponse()->setRedirect($redirectUrl)->sendResponse();

                                return;
                            }
                            $search->setTotalTry($totalTry);
                            $search->setUpdatedAt(date('Y-m-d H:i:s'));
                            $search->save();
                        } else {
                            $data['ip'] = $this->_serverrequest->getServerValue('REMOTE_ADDR');
                            $data['user_agent'] = $this->_serverrequest->getServerValue('HTTP_USER_AGENT');
                            $data['total_try'] = 1;
                            $data['updated_at'] = date('Y-m-d H:i:s');
                            $data['created_at'] = date('Y-m-d H:i:s');
                            $search->setData($data)->save();
                        }
                        $redirectUrl = $this->_urlInterface->getUrl('search-error');
                        $observer->getResponse()->setRedirect($redirectUrl)->sendResponse();

                        return;
                    }
                }
            }
        } else {
            if (!$this->_configHelper->IsEnabled() ||
                ($uri !== null && strpos($uri, 'welcomb/') !== false) ||
                $this->_dataHelper->doesUrlContainsDisquallifiers()
            ) {
                return true;
            }

            $bot = $this->_botFactory->create()->getCollection()
                ->addFieldToFilter('status', 'enabled')
                ->addFieldToFilter('ip', $this->_serverrequest->getServerValue('REMOTE_ADDR'))->getFirstItem();

            /****We have found the BOT, let it be checked********/
            if ($bot->getBotId() && ($bot->getExpiresAt() > date('Y-m-d H:i:s') || $bot->getPermanentlyBlock())) {
                if ($bot->getPermanentlyBlock()) {
                    $redirectUrl = $this->_urlInterface->getUrl('ewbotblocker');
                    $observer->getResponse()->setRedirect($redirectUrl)->sendResponse();

                    return;
                }
                $redirectUrl = $this->_urlInterface->getUrl('ewbotblocker/index/validate');
                $observer->getResponse()->setRedirect($redirectUrl)->sendResponse();
            }
            $response = $observer->getEvent()->getData('response');
            $body = $response->getBody();

            if (($bodyEndPos = stripos($body, '</body>')) === false) {
                return;
            }
            $html = '';
            if ($this->_configHelper->IsFormProtectionEnabled()) {
                if ($uri !== null && strpos($uri, 'checkout/') !== false && $this->_configHelper->IsFormProtectionDisableOnCheckout()) {
                    return;
                }
                $javascript = '';
                if (preg_match_all('/(<form.*?>)/is', $body, $matches)) {
                    foreach ($matches[1] as $form) {
                        $originalForm = $form;

                        if (!preg_match('/id=[\'"](.*?)[\'"]/i', $form, $match)) {
                            continue;
                        }
                        $formId = $match[1];

                        if (!preg_match('/action=[\'"](.*?)[\'"]/i', $form, $match)) {
                            continue;
                        }
                        $action = $match[1];

                        $method = '';
                        if (preg_match('/method=[\'"](.*?)[\'"]/i', $form, $match)) {
                            $method = strtolower($match[1]);
                        }

                        $newAction = '#';
                        $honeypotJs = '';
                        if ($this->_configHelper->IsFormProtectionHoneypottedUrlsEnabled()) {
                            if ($this->_configHelper->isOnlyPostEnabled() === false or $method == 'post') {
                                $honeypotPrefix = $this->_dataHelper->getPathPrefix();
                                $honeypotKey = $this->_dataHelper->getHoneypotKey('form:' . $formId);
                                $newAction = $this->_dataHelper->getHoneypotUrl($honeypotPrefix, $honeypotKey);
                                $honeypotJs = "var el = document.createElement('input');el.setAttribute('type', 'text');el.setAttribute('name', '" . $honeypotKey . "');el.setAttribute('style', 'display:none;'); ___t.appendChild(el);";
                            }
                        }
                        $form = str_replace($action, $newAction, $form);
                        $javascript .= sprintf("
                    <script>
                        document.addEventListener('DOMContentLoaded', function() {
                            var ___t = document.getElementById('%s');
                            if (___t) {
                                ___t.action = '%s';
                                %s
                            }
                        });
                    </script>", $formId, $action, $honeypotJs);

                        $body = str_replace($originalForm, $form, $body);
                    }
                }

                $html .= $javascript;
            }

            $formKey = $this->_formKey->getFormKey();
            if ($this->_configHelper->IsHoneypotFormEnabled()) {
                $html .= preg_replace('/\s+/s', ' ', sprintf('<div class="no-display">
						<form action="%s" method="post">
							<input type="text" name="name"/>
							<input type="text" name="email"/>
							<textarea name="message" rows="5" cols="40"></textarea>
						</form>
						<form action="%s" method="post">
							<input type="text" name="q"/>
							<input type="submit">
						</form>
					</div><style>.no-display{display:none}</style>', $this->_urlInterface->getUrl('welcomb/index/pot', ['form_key' => $formKey]), $this->_urlInterface->getUrl('welcomb/index/pot', ['form_key' => $formKey])));
            }
            if ($this->_configHelper->IsHoneypotLinkEnabled() && !$this->_configHelper->IsOnlyPostEnabled()) {
                $html .= preg_replace('/\s+/s', ' ', sprintf('<div class="no-display">
					<a href="%s" rel="nofollow">click here</a>
					</div><style>.no-display{display:none}</style>', $this->_urlInterface->getUrl('welcomb/index/pot', ['form_key' => $formKey])));
            }
            $body = substr($body, 0, $bodyEndPos) . $html . substr($body, $bodyEndPos);
            $response->setBody($body);
        }
    }
}
