# Extendware Bot Blocker for Magento 2

**Extendware** **Bot Blocker** Stop spam and malicious bots and other bad bots that spam your store and increase your server load by repeatedly crawling your store. Automated and easy to use solution to block bad bots, free up server resources, and reduce the spam that is sent to your store.It also blocks malicious search query keywords being search and spam magento search.

*  Block malicious bots while accessing unauthorized URLs of the website 

*  Block malicious bots on submitting random forms using honeypot technique.

*  Hide form URLs from crawling bot.

*  Block bots to insert malicious code into search bar.
*  Permanently block bot to access website.

*  Google captcha support for identifying human vs bots

*  Work with any forms types: default Magento 2 forms, custom forms, third-party forms


## Why do you need bot blocker for your Magento store?

**Magento Bot Blocker is the best solution to stop spam bots and scraper bots on your store**. Automated bots constantly crawl the web looking for contact forms to submit spam to, review forms to submit spam to, and looking for information to scrape for data mining purposes. These bots increase server load, waste your time with spam messages, and reduce your stores response rate due to increased load.Block malicious bot to insert sql injection in search box Magento Bot Blocker will identify and block these bots so your store can run better and remain active.

### **Consequences of Bots Crawling Your Store**

Malicious bots that crawl your site are looking to spam your store or looking for security weaknesses so they can hack your store. You might have seen in your store search log strange looking queries that are done to gain access to your database. Eventually, many malicious bots crawling your store can even cause store response time to reduce which can impact search engine ranking and conversions on your store.

### **Bot Blocker Solution to Bots**

Magento Bot Blocker adds hidden forms on your store which bad bots will submit to and be identified. Good bots will not submit to forms on your site. A hidden link with a nofollow attribute can also be added to identify bad bots. In addition, existing forms will be rewritten to trick bad bots while not affecting users. **Using these techniques, Bot Blocker can identify the bad bots and block them from your store!**

### **Bot Blocker Honeypot Solution To Block Random Form Submission**

Honeypot is a hidden form, which the extension adds to protect from bot attacks. Honeypot is user-friendly, normal users won't see hidden honeypot inputs. However, spambots can see the hidden honeypot form as another form, and if they fill the hidden honeypot form, and try to submit, the form will fail to submit and bot added to blocklist.


## Installation in your Magento Online Shop

### **Interested in Extension Installation ?**

Visite our installation service page [https://www.extendware.com/magento-extension-installation-service.html](https://www.extendware.com/magento-extension-installation-service.html) for more information

Got questions? Feel free to contact us! [Support Form](https://support.extendware.com/).

### **Installation procedure**



1. Download your extension package from the [Download](https://www.extendware.com/downloadable/customer/products/) page after purchasing the extension.
2. Open the extension ZIP file you downloaded and extract it to a directory on your computer using a tool like WinRar, WinZIP or similar.
3. Upload the extracted folders and files into the root directory of your Magento installation. The root directory of Magento is the folder that contains the directories "app", "bin", "lib" and more. All folders should match the existing folder structure. If one of our extensions is already installed and you're updating it, make sure to overwrite the existing files of the extension.
4. Connect via SSH and run the following commands (make sure to run them as the user who owns the Magento files!
5. php bin/magento module:enable --clear-static-content Extendware_Core
6. php bin/magento module:enable --clear-static-content Extendware_EWBotBlocker
7. php bin/magento maintenance:enable 
8. php bin/magento setup:upgrade
9. php bin/magento setup:di:compile
10. php bin/magento setup:static-content:deploy
11. php bin/magento maintenance:disable
12. In case if you still do not see the extension active, Go to Admin -> System > Cache Management and click both the 'Flush Magento Cache' as well as the 'Flush Cache Storage' button.
13. Woo-ha! You have successfully installed the extension and your store is ready to protect from spammers and bad bots.


## User manual

**You will find all extendware settings in Admin Panel → Extendware Menu**

![alt_text](docs/images/image1.png "image_tooltip")


**Extendware Bots** - To see blocklisted bots, Add new bot manually and edit existing bot.

**Test as bot** - It will make admin ip as bot to see how website will look if bot try to access website and you test configuration as bot.

**Configuration** - It will redirect admin on bot blocker configuration when admin can configure bot blocker extension.

**To configure the extension you need to go to Admin Panel → Extendware Menu → Configuration.**



![alt_text](docs/images/image2.png "image_tooltip")


### **General Configuration**

**Module Enabled** - Select Yes to enable the extension.

**Newly Added Bot Default Status Pending** - What to do with newly detected bot, choose “yes” if you want it to approve manually. If it is yes then the newly detected bot will save in admin but access to the website will not be blocked for new bots.(Recommend to set it “No”)

**Honeypot Form Detection** - A honeypot form will be added to the document which will be invisible for the human being but bot can access it (Recommend to set it “Yes”).

**Honeypot Link Detection** - An invisible link will be added to the document (Recommend to set it “Yes”).

**Form Protection** - If enabled, then the "action" attribute of forms will be removed and added back with Javascript. With these tricks bots will not know how to submit the form.

**Form Protection Honeypotted Urls** - If ”Yes”, then the "action" attribute will be rewritten to a url that if it receives traffic the bot will be banned. Normal browsers with javascript will use the correct action url so users will not be affected. **Note:** Test each form after enabling and adding any incompatible forms to the "Form Protection Excluded Forms" list in Advance Configuration.

**Search bot configuration to protect search bar to inject malicious code.**


![alt_text](docs/images/image3.png "image_tooltip")


### **Ban Search keyword**

**Search Ban Enable** - Select Yes to enable Search Ban.

**Ban Keywords** - Use this to restrict keywords from being searched on the store, based on those keyword search bot will identify and ban those users from the website. You can add a specific keyword or Regexp to identify the search bot. \
 \
Keyword : If keyword found in search query then request will be blocked. \
Regexp : If the search query matches with regexp then the request will be blocked.

If the request is blocked then the system will redirect the customer to the search error CMS page and the admin can manage content from Admin Panel → Content → Pages.

**Permanently Ban From website** - If Yes, Extension will Permanently block IP addresses if they exceed the Ban keyword limit.

**Ban keyword limit** - If a customer tries a bad keyword for more than the allowed limit, the customer's ip will be permanently blocked automatically. You can define the allowed limit here.

**Contact Email** - Once a Bot is blocked then they do not access any page of the website. When those user try to access website they will see error message with email to contact,This email will be display to user and they can contact if they get block and they are not bot, so admin can remove them from block list (If it's empty then system will use store email address).

**Advanced configuration to protect from advanced bot.**



![alt_text](docs/images/image4.png "image_tooltip")


### **Advance Configuration**

**Honeypot Paths RegExp** - Some bots randomly try urls such as "admin" to try to identify your stores platform. You can add any such urls like this to auto-block anyone that visits them.

**IP Mode** - If your store is behind a load balance, you should use the forwarded mode.

**Path Prefix** - This will be prepended to honey pot urls. You should also add this to your robots.txt file to ensure good bots never got to the url. This is important if you enabled "**Honeypot Link Detection**".

**Only Post** - If “Yes”, the bot will only be rejected if they send a POST request on a honey-potted url. With this enabled, honey-potted links using the "nofollow" attribute will not be outputted. Also, honey-potted form protection urls will only be placed on forms with a method of POST.

**Verification Cookie** - If “Yes”, the session will only check if it is a bot once per session.

**Ban Length (days)** - The maximum length of time in days that a ban of a bot will be in effect.

**Form Protection Excluded Forms** - Input a form ID of a form if you want it to be ignored by the form protection.

**Uri Filter RegExps** - This will disable bot blocker on certain pages. Mostly useful for ensuring that admin pages do not use it when testing.

**Salt** - Changing this will change your honeypot urls. It is useful to change this if you want to invalidate old urls due to change in settings or something similar.

**Recaptcha Public Key** - Google recaptcha Public key ([https://www.google.com/recaptcha/admin](https://www.google.com/recaptcha/admin)) .

**Recaptcha Secret Key** - Google recaptcha Secret key ([https://www.google.com/recaptcha/admin](https://www.google.com/recaptcha/admin)) .

**To see and manage block list you need to go Admin Panel → Extendware Menu → Extendware Bots**


![alt_text](docs/images/image5.png "image_tooltip")


Here admin can see all blocked bots/users that were trying to harm the website. When a bad bot try to access website and harm website, bot blocker extension will automatically identify bot and added them to above blocklist. Admin can review those bot from the list.

Admin also can edit bot settings like to enable/disable bot , change bot ban time in days,  make it ban permanently or disable permanently ban.

### **New Bot configuration page to add bot manually**


![alt_text](docs/images/image6.png "image_tooltip")


To add a bot manually, admin can click on the “Add New Bot” button from the top right corner. Where an admin can add new bot IP manually and configure particular bot behavior.


## How does the bot blocker work?

### **Google Captcha Verification page to identify bot vs human**


![alt_text](docs/images/image7.png "image_tooltip")


When the system identifies a bot and bot status is not pending then the system will automatically add bot IP address into bot blocker list and enable restriction for bot IP addresses.

So when Bot try to access any page of the website system will redirect that bot to human verification page, verification page is built with google captcha to identify human vas bot.

Bots can not verify google captcha and they can not gain access to any other page of the website and can not crawl your store.

### **Humans can verify google captcha and get access of website.**


![alt_text](docs/images/image8.png "image_tooltip")


In case if any human is identified as a bot then they can simply verify Google captcha to again gain access to the website.

### **Search ban page.**


![alt_text](docs/images/image9.png "image_tooltip")


If any user/bot tries to use restricted keywords and Regexp in search then they will redirect to the warning page to notify users that they are using banned keywords in the search bar and then can get permanently blocked from the website if they keep using restricted keywords.

### **Permanently banned bots/users will be restricted to access the website.**


![alt_text](docs/images/image10.png "image_tooltip")


If users/bots keep trying to ban keywords in search bar like sql injection etc and if they exceed the allowed limit then those users/bots will be banned from the website completely. They can see only the restriction message and email id to contact if they want to access website again.

## Changelog
All notable changes to this project will be documented in this file.

## [1.3.2]
### Added
- Support for whitelisted IP's.
- Support for whitelisted User-Agent.

## [1.3.1]
### Fixed
- Fix: HoneyPot link stop working due to the wrong body position count

## [1.3.0]
### Added
- Support Hyva theme.
- Enahnce the honeypot functionlaity.

### Fixed
- Fixed issue with the form protection configuration

## [1.2.9]
### Added
- Fix : PHP 8.2 issues
- Support Multi-store

## [1.2.8]
### Added
- Upadte honey port check for admin area.

### [1.2.7]
#### Added
- Support Magento 2.4.6-p2
- Update extension menu sorting

### [1.2.6]
#### Added
- Support Magento 2.4.6 with PHP8.2

### [1.2.5]
#### Added
-  Fix `strpos()` issue incase url not define 

### [1.2.4]
#### Added
    Minor code sniffer fixes

### [1.2.3]
#### Added
    Support Magento 2.4.6 with PHP8.1

### [1.2.2]
#### Added
    First release