<?php
/*
 * web-vision GmbH
 * Do not edit or add to this file if you wish to upgrade Magento to newer
 * versions in the future. If you wish to customize Magento for your
 * needs please refer to https://www.web-vision.de for more information.
 * @category    Extendware
 * @copyright   Copyright (c) 2001-2022 web-vision GmbH (https://www.web-vision.de)
 * @author      Mahesh Makwana <mmakwana@web-vision.de>
 */
declare(strict_types=1);
namespace Extendware\ImportDataUI\Api\Data;

interface ImportHistoryInterface
{
    const ENTITY_ID = 'entity_id';
    const MESSAGE = 'message';
    const PROFILE_NAME = 'profile_name';
    const CRON_STATUS = 'cron_status';
    const FILE_NAME = 'file_name';
    const END_DATE = 'end_date';
    const START_DATE = 'start_date';
    const IMPORTHISTORY_ID = 'importhistory_id';
    const STATUS = 'status';

    /**
     * Get importhistory_id
     *
     * @return string|null
     */
    public function getImporthistoryId();

    /**
     * Set importhistory_id
     *
     * @param string $importhistoryId
     *
     * @return \Extendware\ImportDataUI\ImportHistory\Api\Data\ImportHistoryInterface
     */
    public function setImporthistoryId($importhistoryId);

    /**
     * Get entity_id
     *
     * @return string|null
     */
    public function getEntityId();

    /**
     * Set entity_id
     *
     * @param string $entityId
     *
     * @return \Extendware\ImportDataUI\ImportHistory\Api\Data\ImportHistoryInterface
     */
    public function setEntityId($entityId);

    /**
     * Get profile_name
     *
     * @return string|null
     */
    public function getProfileName();

    /**
     * Set profile_name
     *
     * @param string $profileName
     *
     * @return \Extendware\ImportDataUI\ImportHistory\Api\Data\ImportHistoryInterface
     */
    public function setProfileName($profileName);

    /**
     * Get file_name
     *
     * @return string|null
     */
    public function getFileName();

    /**
     * Set file_name
     *
     * @param string $fileName
     *
     * @return \Extendware\ImportDataUI\ImportHistory\Api\Data\ImportHistoryInterface
     */
    public function setFileName($fileName);

    /**
     * Get status
     *
     * @return string|null
     */
    public function getStatus();

    /**
     * Set status
     *
     * @param string $status
     *
     * @return \Extendware\ImportDataUI\ImportHistory\Api\Data\ImportHistoryInterface
     */
    public function setStatus($status);

    /**
     * Get cron_status
     *
     * @return string|null
     */
    public function getCronStatus();

    /**
     * Set cron_status
     *
     * @param string $cronStatus
     *
     * @return \Extendware\ImportDataUI\ImportHistory\Api\Data\ImportHistoryInterface
     */
    public function setCronStatus($cronStatus);

    /**
     * Get message
     *
     * @return string|null
     */
    public function getMessage();

    /**
     * Set message
     *
     * @param string $message
     *
     * @return \Extendware\ImportDataUI\ImportHistory\Api\Data\ImportHistoryInterface
     */
    public function setMessage($message);

    /**
     * Get start_date
     *
     * @return string|null
     */
    public function getStartDate();

    /**
     * Set start_date
     *
     * @param string $startDate
     *
     * @return \Extendware\ImportDataUI\ImportHistory\Api\Data\ImportHistoryInterface
     */
    public function setStartDate($startDate);

    /**
     * Get end_date
     *
     * @return string|null
     */
    public function getEndDate();

    /**
     * Set end_date
     *
     * @param string $endDate
     *
     * @return \Extendware\ImportDataUI\ImportHistory\Api\Data\ImportHistoryInterface
     */
    public function setEndDate($endDate);
}
