<?php
/*
 * web-vision GmbH
 * Do not edit or add to this file if you wish to upgrade Magento to newer
 * versions in the future. If you wish to customize Magento for your
 * needs please refer to https://www.web-vision.de for more information.
 * @category    Extendware
 * @copyright   Copyright (c) 2001-2022 web-vision GmbH (https://www.web-vision.de)
 * @author      Mahesh Makwana <mmakwana@web-vision.de>
 */
declare(strict_types=1);
namespace Extendware\ImportDataUI\Api;

interface ImportHistoryRepositoryInterface
{
    /**
     * Save ImportHistory
     *
     * @param \Extendware\ImportDataUI\Api\Data\ImportHistoryInterface $importHistory
     *
     * @throws \Magento\Framework\Exception\LocalizedException
     *
     * @return \Extendware\ImportDataUI\Api\Data\ImportHistoryInterface
     */
    public function save(
        \Extendware\ImportDataUI\Api\Data\ImportHistoryInterface $importHistory
    );

    /**
     * Retrieve ImportHistory
     *
     * @param string $importhistoryId
     *
     * @throws \Magento\Framework\Exception\LocalizedException
     *
     * @return \Extendware\ImportDataUI\Api\Data\ImportHistoryInterface
     */
    public function get($importhistoryId);

    /**
     * Retrieve ImportHistory matching the specified criteria.
     *
     * @param \Magento\Framework\Api\SearchCriteriaInterface $searchCriteria
     *
     * @throws \Magento\Framework\Exception\LocalizedException
     *
     * @return \Extendware\ImportDataUI\Api\Data\ImportHistorySearchResultsInterface
     */
    public function getList(
        \Magento\Framework\Api\SearchCriteriaInterface $searchCriteria
    );

    /**
     * Delete ImportHistory
     *
     * @param \Extendware\ImportDataUI\Api\Data\ImportHistoryInterface $importHistory
     *
     * @throws \Magento\Framework\Exception\LocalizedException
     *
     * @return bool true on success
     */
    public function delete(
        \Extendware\ImportDataUI\Api\Data\ImportHistoryInterface $importHistory
    );

    /**
     * Delete ImportHistory by ID
     *
     * @param string $importhistoryId
     *
     * @throws \Magento\Framework\Exception\NoSuchEntityException
     * @throws \Magento\Framework\Exception\LocalizedException
     *
     * @return bool true on success
     */
    public function deleteById($importhistoryId);
}
