<?php
/*
 * web-vision GmbH
 * Do not edit or add to this file if you wish to upgrade Magento to newer
 * versions in the future. If you wish to customize Magento for your
 * needs please refer to https://www.web-vision.de for more information.
 * @category    Extendware
 * @copyright   Copyright (c) 2001-2022 web-vision GmbH (https://www.web-vision.de)
 * @author      Mahesh Makwana <mmakwana@web-vision.de>
 */
declare(strict_types=1);
namespace Extendware\ImportDataUI\Controller\Adminhtml\ImportHistory;

use Extendware\ImportDataUI\Cron\RunProfiler;
use Magento\Framework\App\Filesystem\DirectoryList;

class Delete extends \Extendware\ImportDataUI\Controller\Adminhtml\ImportHistory
{
    /**
     * @var \Magento\Framework\Registry
     */
    protected $_coreRegistry;

    /**
     * @var \Magento\Framework\App\Filesystem\DirectoryList
     */
    protected $directoryList;

    /**
     * @var \Magento\Framework\Filesystem\Driver\File
     */
    protected $_file;

    /**
     * @param \Magento\Backend\App\Action\Context $context
     * @param \Magento\Framework\Registry $coreRegistry
     * @param \Magento\Framework\App\Filesystem\DirectoryList $directoryList
     * @param \Magento\Framework\Filesystem\Driver\File $file
     */
    public function __construct(
        \Magento\Backend\App\Action\Context $context,
        \Magento\Framework\Registry $coreRegistry,
        \Magento\Framework\App\Filesystem\DirectoryList $directoryList,
        \Magento\Framework\Filesystem\Driver\File $file
    ) {
        $this->_coreRegistry = $coreRegistry;
        $this->directoryList = $directoryList;
        $this->_file = $file;
        parent::__construct($context, $coreRegistry);
    }

    /**
     * Delete action
     *
     * @return \Magento\Framework\Controller\ResultInterface
     */
    public function execute()
    {
        /** @var \Magento\Backend\Model\View\Result\Redirect $resultRedirect */
        $resultRedirect = $this->resultRedirectFactory->create();
        // check if we know what should be deleted
        $id = $this->getRequest()->getParam('importhistory_id');
        if ($id) {
            try {
                // init model and delete
                $model = $this->_objectManager->create(\Extendware\ImportDataUI\Model\ImportHistory::class);
                $model->load($id);
                $filePath = $this->directoryList->getPath(DirectoryList::MEDIA) . '/' . RunProfiler::HISTORY_FILE_PATH . '/';
                $filePath .= $model->getFileName();
                if (($this->_file->isExists($filePath)) && ($model->getFileName())) {
                    $this->_file->deleteFile($filePath);
                }
                $model->delete();
                // display success message
                $this->messageManager->addSuccessMessage(__('You deleted the Import Cron.'));
                // go to grid
                return $resultRedirect->setPath('*/*/');
            } catch (\Exception $e) {
                // display error message
                $this->messageManager->addErrorMessage($e->getMessage());
                // go back to edit form
                return $resultRedirect->setPath('*/*/edit', ['importhistory_id' => $id]);
            }
        }
        // display error message
        $this->messageManager->addErrorMessage(__('We can\'t find a Import Cron to delete.'));
        // go to grid
        return $resultRedirect->setPath('*/*/');
    }
}
