<?php
/*
 * web-vision GmbH
 * Do not edit or add to this file if you wish to upgrade Magento to newer
 * versions in the future. If you wish to customize Magento for your
 * needs please refer to https://www.web-vision.de for more information.
 * @category    Extendware
 * @copyright   Copyright (c) 2001-2022 web-vision GmbH (https://www.web-vision.de)
 * @author      Mahesh Makwana <mmakwana@web-vision.de>
 */
declare(strict_types=1);
namespace Extendware\ImportDataUI\Controller\Adminhtml\ImportHistory;

use Magento\Framework\App\Filesystem\DirectoryList;
use Extendware\ImportDataUI\Cron\RunProfiler;

class MassDelete extends \Extendware\ImportDataUI\Controller\Adminhtml\ImportHistory
{
    /**
     * @var \Magento\Framework\Registry
     */
    protected $_coreRegistry;

    /**
     * @var \Magento\Framework\App\Filesystem\DirectoryList
     */
    protected $directoryList;

    /**
     * @var \Magento\Framework\Filesystem\Driver\File
     */
    protected $_file;

    /**
     * @var \Extendware\ImportDataUI\Model\ResourceModel\ImportHistory\CollectionFactory
     */
    protected $collectionFactory;

    /**
     * @var \Magento\Ui\Component\MassAction\Filter
     */
    protected $filter;

    /**
     * @param \Magento\Backend\App\Action\Context $context
     * @param \Magento\Framework\Registry $coreRegistry
     * @param \Magento\Framework\App\Filesystem\DirectoryList $directoryList
     * @param \Magento\Framework\Filesystem\Driver\File $file
     * @param \Extendware\ImportDataUI\Model\ResourceModel\ImportHistory\CollectionFactory $collectionFactory
     * @param \Magento\Ui\Component\MassAction\Filter $filter
     */
    public function __construct(
        \Magento\Backend\App\Action\Context $context,
        \Magento\Framework\Registry $coreRegistry,
        \Magento\Framework\App\Filesystem\DirectoryList $directoryList,
        \Magento\Framework\Filesystem\Driver\File $file,
        \Extendware\ImportDataUI\Model\ResourceModel\ImportHistory\CollectionFactory $collectionFactory,
        \Magento\Ui\Component\MassAction\Filter $filter
    ) {
        $this->_coreRegistry = $coreRegistry;
        $this->directoryList = $directoryList;
        $this->_file = $file;
        $this->collectionFactory = $collectionFactory;
        $this->filter = $filter;
        parent::__construct($context, $coreRegistry);
    }

    /**
     * Mass Delete action
     *
     * @return \Magento\Framework\Controller\ResultInterface
     */
    public function execute()
    {
        /** @var \Magento\Backend\Model\View\Result\Redirect $resultRedirect */
        $resultRedirect = $this->resultRedirectFactory->create();
        try {
            // get mass delete data
            $selectedData = $this->filter->getCollection($this->collectionFactory->create());
            foreach ($selectedData as $item) {
                // get history file path for delete
                $filePath = $this->directoryList->getPath(DirectoryList::MEDIA) . '/' . RunProfiler::HISTORY_FILE_PATH . '/';
                $filePath .= $item->getFileName();
                if (($this->_file->isExists($filePath)) && ($item->getFileName())) {
                    $this->_file->deleteFile($filePath);
                }
                // delete import cron
                $item->delete();
            }
            $this->messageManager->addSuccessMessage(__('You have successfully deleted the selected Import Cron.'));
        } catch (\Exception $e) {
            $this->messageManager->addErrorMessage($e->getMessage());
        }

        return $resultRedirect->setPath('*/*/');
    }
}
