<?php
/*
 * web-vision GmbH
 * Do not edit or add to this file if you wish to upgrade Magento to newer
 * versions in the future. If you wish to customize Magento for your
 * needs please refer to https://www.web-vision.de for more information.
 * @category    Extendware
 * @copyright   Copyright (c) 2001-2022 web-vision GmbH (https://www.web-vision.de)
 * @author      Mahesh Makwana <mmakwana@web-vision.de>
 */
declare(strict_types=1);
namespace Extendware\ImportDataUI\Controller\Adminhtml\ImportHistory;

use Magento\Framework\Exception\LocalizedException;

class Save extends \Magento\Backend\App\Action
{
    /**
     * @var \Magento\Framework\App\Request\DataPersistorInterface
     */
    protected $dataPersistor;

    /**
     * @var \Extendware\ImportDataUI\Model\Config\Source\ProfilerName
     */
    protected $profilerNameList;

    /**
     * @param \Magento\Backend\App\Action\Context $context
     * @param \Extendware\ImportDataUI\Model\Config\Source\ProfilerName $profilerNameList,
     * @param \Magento\Framework\App\Request\DataPersistorInterface $dataPersistor
     */
    public function __construct(
        \Magento\Backend\App\Action\Context $context,
        \Extendware\ImportDataUI\Model\Config\Source\ProfilerName $profilerNameList,
        \Magento\Framework\App\Request\DataPersistorInterface $dataPersistor
    ) {
        $this->dataPersistor = $dataPersistor;
        $this->profilerNameList = $profilerNameList;
        parent::__construct($context);
    }

    /**
     * Save action
     *
     * @return \Magento\Framework\Controller\ResultInterface
     */
    public function execute()
    {
        /** @var \Magento\Backend\Model\View\Result\Redirect $resultRedirect */
        $resultRedirect = $this->resultRedirectFactory->create();
        $data = $this->getRequest()->getPostValue();
        if ($data) {
            $id = $this->getRequest()->getParam('importhistory_id');

            $model = $this->_objectManager->create(\Extendware\ImportDataUI\Model\ImportHistory::class)->load($id);
            if (!$model->getId() && $id) {
                $this->messageManager->addErrorMessage(__('This Import Cron no longer exists.'));

                return $resultRedirect->setPath('*/*/');
            }

            // Update affected Categories
            if(isset($data['affected_category'])){
                $data['affected_category'] = implode(',', $data['affected_category'] ?? []);
            } else {
                $data['affected_category'] = '';
            }

            $data = $this->setProfileName($data);
            $model->setData($data);

            try {
                $model->save();
                $this->messageManager->addSuccessMessage(__('You saved the Import Cron.'));
                $this->dataPersistor->clear('extendware_importdataui_importhistory');

                if ($this->getRequest()->getParam('back')) {
                    return $resultRedirect->setPath('*/*/edit', ['importhistory_id' => $model->getId()]);
                }

                return $resultRedirect->setPath('*/*/');
            } catch (LocalizedException $e) {
                $this->messageManager->addErrorMessage($e->getMessage());
            } catch (\Exception $e) {
                $this->messageManager->addExceptionMessage($e, __('Something went wrong while saving the Import Cron.'));
            }

            $this->dataPersistor->set('extendware_importdataui_importhistory', $data);

            return $resultRedirect->setPath('*/*/edit', ['importhistory_id' => $this->getRequest()->getParam('importhistory_id')]);
        }

        return $resultRedirect->setPath('*/*/');
    }

    /**
     * Set profile name
     *
     * @param array $data
     *
     * @return array
     */
    public function setProfileName($data)
    {
        if (isset($data['profile_name'])) {
            $list = $this->profilerNameList->toOptionArray();
            foreach ($list as $listKey => $listVal) {
                if ($data['profile_name'] == $listVal['value']) {
                    $data['profile_name_show'] = $listVal['label']->getText();

                    break;
                }
            }
        }

        return $data;
    }
}
