<?php
/*
 * web-vision GmbH
 * Do not edit or add to this file if you wish to upgrade Magento to newer
 * versions in the future. If you wish to customize Magento for your
 * needs please refer to https://www.web-vision.de for more information.
 * @category    Extendware
 * @copyright   Copyright (c) 2001-2024 web-vision GmbH (https://www.web-vision.de)
 * @author      Mahesh Makwana <mmakwana@web-vision.de>
 */
namespace Extendware\ImportDataUI\Helper;

use Magento\Framework\App\Config\ScopeConfigInterface;
use Magento\Framework\App\Helper\AbstractHelper;
use Magento\Framework\App\Helper\Context;
use Magento\Store\Model\ScopeInterface;

class Data extends AbstractHelper
{
    public const MHSI_CRON_AUTH = 'mhsi_cron/general/auth_enable';

    public const MHSI_CRON_AUTH_USER = 'mhsi_cron/general/auth_user';

    public const MHSI_CRON_AUTH_PASS = 'mhsi_cron/general/auth_pass';

    /**
     * @var ScopeConfigInterface
     */
    protected $scopeConfig;

    /**
     * Init
     *
     * @param Context $context
     * @param ScopeConfigInterface $scopeConfig
     */
    public function __construct(
        Context $context,
        ScopeConfigInterface $scopeConfig
    ) {
        $this->scopeConfig = $scopeConfig;
        parent::__construct($context);
    }

    /**
     * Get module status
     *
     * @return string
     */
    public function getMhsiAuthStatus()
    {
        return $this->scopeConfig->getValue(
            self::MHSI_CRON_AUTH,
            ScopeInterface::SCOPE_STORE
        );
    }

    /**
     * Get username
     *
     * @return string
     */
    public function getUserName()
    {
        return $this->scopeConfig->getValue(
            self::MHSI_CRON_AUTH_USER,
            ScopeInterface::SCOPE_STORE
        );
    }

    /**
     * Get password
     *
     * @return string
     */
    public function getPassword()
    {
        return $this->scopeConfig->getValue(
            self::MHSI_CRON_AUTH_PASS,
            ScopeInterface::SCOPE_STORE
        );
    }
}
