<?php
/*
 * web-vision GmbH
 * Do not edit or add to this file if you wish to upgrade Magento to newer
 * versions in the future. If you wish to customize Magento for your
 * needs please refer to https://www.web-vision.de for more information.
 * @category    Extendware
 * @copyright   Copyright (c) 2001-2022 web-vision GmbH (https://www.web-vision.de)
 * @author      Mahesh Makwana <mmakwana@web-vision.de>
 */
namespace Extendware\ImportDataUI\Model\Config\Source;

class CronStatus implements \Magento\Framework\Option\ArrayInterface
{
    public const CRON_PENDING = '0';

    public const CRON_SUCCESS = '1';

    public const CRON_CANCEL = '2';

    public const CRON_FAILED = '3';

    public const CRON_PROCESS = '4';

    /**
     * Options for Type
     *
     * @return array
     */
    public function toOptionArray()
    {
        return [
            ['value' => self::CRON_PENDING, 'label' => __('Pending')],
            ['value' => self::CRON_SUCCESS, 'label' => __('Success')],
            ['value' => self::CRON_CANCEL, 'label' => __('Cancel')],
            ['value' => self::CRON_FAILED, 'label' => __('Failed')],
            ['value' => self::CRON_PROCESS, 'label' => __('Process')],
        ];
    }
}
