<?php
/*
 * web-vision GmbH
 * Do not edit or add to this file if you wish to upgrade Magento to newer
 * versions in the future. If you wish to customize Magento for your
 * needs please refer to https://www.web-vision.de for more information.
 * @category    Extendware
 * @copyright   Copyright (c) 2001-2022 web-vision GmbH (https://www.web-vision.de)
 * @author      Mahesh Makwana <mmakwana@web-vision.de>
 */
namespace Extendware\ImportDataUI\Model\Config\Source;

class ProfilerName implements \Magento\Framework\Option\ArrayInterface
{
    public const MHSI_PROFILE_PATH = 'mhsi/bin/';

    /**
     * @var \Magento\Framework\Filesystem\DirectoryList
     */
    protected $directoryList;

    /**
     * @var \Magento\Framework\Filesystem\Driver\File
     */
    protected $driverFile;

    /**
     * GetDeliveryData constructor.
     *
     * @param \Magento\Framework\Filesystem\DirectoryList $directoryList
     * @param \Magento\Framework\Filesystem\Driver\File $driverFile
     */
    public function __construct(
        \Magento\Framework\Filesystem\DirectoryList $directoryList,
        \Magento\Framework\Filesystem\Driver\File $driverFile
    ) {
        $this->directoryList = $directoryList;
        $this->driverFile = $driverFile;
    }

    /**
     * Options for Type
     *
     * @return array
     */
    public function toOptionArray()
    {
        $fileOptions = $paths = [];

        try {
            $path = $this->directoryList->getRoot() . '/' . self::MHSI_PROFILE_PATH;
            $paths = $this->driverFile->readDirectory($path);
            foreach ($paths as $key => $value) {
                $pathInfo = pathinfo($value);
                if ((isset($pathInfo['extension'])) && ($pathInfo['extension'] == 'xml')) {
                    $fileOptions[] = ['value' => $pathInfo['basename'], 'label' => __($pathInfo['filename'])];
                }
            }
        } catch (FileSystemException $e) {
            $this->logger->error($e->getMessage());
        }

        return $fileOptions;
    }
}
