<?php
/*
 * web-vision GmbH
 * Do not edit or add to this file if you wish to upgrade Magento to newer
 * versions in the future. If you wish to customize Magento for your
 * needs please refer to https://www.web-vision.de for more information.
 * @category    Extendware
 * @copyright   Copyright (c) 2001-2022 web-vision GmbH (https://www.web-vision.de)
 * @author      Mahesh Makwana <mmakwana@web-vision.de>
 */
declare(strict_types=1);
namespace Extendware\ImportDataUI\Model;

use Extendware\ImportDataUI\Api\Data\ImportHistoryInterface;
use Magento\Framework\Model\AbstractModel;

class ImportHistory extends AbstractModel implements ImportHistoryInterface
{
    /**
     * @inheritDoc
     */
    public function _construct()
    {
        $this->_init(\Extendware\ImportDataUI\Model\ResourceModel\ImportHistory::class);
    }

    /**
     * @inheritDoc
     */
    public function getImporthistoryId()
    {
        return $this->getData(self::IMPORTHISTORY_ID);
    }

    /**
     * @inheritDoc
     */
    public function setImporthistoryId($importhistoryId)
    {
        return $this->setData(self::IMPORTHISTORY_ID, $importhistoryId);
    }

    /**
     * @inheritDoc
     */
    public function getEntityId()
    {
        return $this->getData(self::ENTITY_ID);
    }

    /**
     * @inheritDoc
     */
    public function setEntityId($entityId)
    {
        return $this->setData(self::ENTITY_ID, $entityId);
    }

    /**
     * @inheritDoc
     */
    public function getProfileName()
    {
        return $this->getData(self::PROFILE_NAME);
    }

    /**
     * @inheritDoc
     */
    public function setProfileName($profileName)
    {
        return $this->setData(self::PROFILE_NAME, $profileName);
    }

    /**
     * @inheritDoc
     */
    public function getFileName()
    {
        return $this->getData(self::FILE_NAME);
    }

    /**
     * @inheritDoc
     */
    public function setFileName($fileName)
    {
        return $this->setData(self::FILE_NAME, $fileName);
    }

    /**
     * @inheritDoc
     */
    public function getStatus()
    {
        return $this->getData(self::STATUS);
    }

    /**
     * @inheritDoc
     */
    public function setStatus($status)
    {
        return $this->setData(self::STATUS, $status);
    }

    /**
     * @inheritDoc
     */
    public function getCronStatus()
    {
        return $this->getData(self::CRON_STATUS);
    }

    /**
     * @inheritDoc
     */
    public function setCronStatus($cronStatus)
    {
        return $this->setData(self::CRON_STATUS, $cronStatus);
    }

    /**
     * @inheritDoc
     */
    public function getMessage()
    {
        return $this->getData(self::MESSAGE);
    }

    /**
     * @inheritDoc
     */
    public function setMessage($message)
    {
        return $this->setData(self::MESSAGE, $message);
    }

    /**
     * @inheritDoc
     */
    public function getStartDate()
    {
        return $this->getData(self::START_DATE);
    }

    /**
     * @inheritDoc
     */
    public function setStartDate($startDate)
    {
        return $this->setData(self::START_DATE, $startDate);
    }

    /**
     * @inheritDoc
     */
    public function getEndDate()
    {
        return $this->getData(self::END_DATE);
    }

    /**
     * @inheritDoc
     */
    public function setEndDate($endDate)
    {
        return $this->setData(self::END_DATE, $endDate);
    }
}
