<?php
/*
 * web-vision GmbH
 * Do not edit or add to this file if you wish to upgrade Magento to newer
 * versions in the future. If you wish to customize Magento for your
 * needs please refer to https://www.web-vision.de for more information.
 * @category    Extendware
 * @copyright   Copyright (c) 2001-2022 web-vision GmbH (https://www.web-vision.de)
 * @author      Mahesh Makwana <mmakwana@web-vision.de>
 */
namespace Extendware\ImportDataUI\Ui\Component\Listing\Column;

use Extendware\ImportDataUI\Cron\RunProfiler;
use Magento\Framework\View\Element\UiComponent\ContextInterface;
use Magento\Framework\View\Element\UiComponentFactory;
use Magento\Store\Model\StoreManagerInterface;
use Magento\Ui\Component\Listing\Columns\Column;
use Extendware\ImportDataUI\Model\Config\Source\CronStatus;

class DownloadAction extends Column
{
    /**
     * @var StoreManagerInterface
     */
    private $_storeManager;

    /** Url Path */
    const ORDER_URL_PATH_EDIT = 'sales/order/view';

    public function __construct(
        ContextInterface $context,
        UiComponentFactory $uiComponentFactory,
        StoreManagerInterface $storeManager,
        array $components = [],
        array $data = []
    ) {
        parent::__construct($context, $uiComponentFactory, $components, $data);
        $this->_storeManager = $storeManager;
    }

    /**
     * Prepare Data Source
     *
     * @param array $dataSource
     *
     * @return void
     */
    public function prepareDataSource(array $dataSource)
    {
        if (isset($dataSource['data']['items'])) {
            foreach ($dataSource['data']['items'] as &$item) {
                $name = $this->getData('name');
                if (isset($item['importhistory_id'])) {
                    if (($item['file_name']) && ($item['cron_status'] == CronStatus::CRON_SUCCESS))  {
                        $mediaUrl = $this ->_storeManager->getStore()->getBaseUrl(\Magento\Framework\UrlInterface::URL_TYPE_MEDIA);
                        $mediaUrl .= RunProfiler::HISTORY_FILE_PATH . '/' . $item['file_name'];
                        $item[$name] = html_entity_decode(
                            '<a target="_blank" href="' . $mediaUrl . '" download>Download</a>'
                        );
                    } else {
                        $item[$name] = 'NA';
                    }
                }
            }
        }

        return $dataSource;
    }
}
