<?php
/*
 * web-vision GmbH
 * Do not edit or add to this file if you wish to upgrade Magento to newer
 * versions in the future. If you wish to customize Magento for your
 * needs please refer to https://www.web-vision.de for more information.
 * @category    Extendware
 * @copyright   Copyright (c) 2001-2022 web-vision GmbH (https://www.web-vision.de)
 * @author      Mahesh Makwana <mmakwana@web-vision.de>
 */
namespace Extendware\ManufacturerLogo\Block;

use Extendware\ManufacturerLogo\Helper\Data;
use Magento\Catalog\Model\CategoryRepository;
use Magento\Framework\Registry;
use Magento\Framework\View\Element\Template;
use Magento\Framework\View\Element\Template\Context;
use Psr\Log\LoggerInterface;

class ShowLogo extends Template
{
    /**
     * @var Data
     */
    protected $exAttLogoHelper;

    /**
     * @var Registry
     */
    protected $_registry;

    /**
     * @var CategoryRepository
     */
    protected $categoryRepository;

    /**
     * @var LoggerInterface
     */
    protected $logger;

    /**
     *
     * @param Context $context
     * @param Data $exAttLogoHelper
     * @param CategoryRepository $categoryRepository
     * @param Registry $registry
     * @param LoggerInterface $logger
     * @param array $data
     */
    public function __construct(
        Context $context,
        Data $exAttLogoHelper,
        CategoryRepository $categoryRepository,
        Registry $registry,
        LoggerInterface $logger,
        array $data = []
    ) {
        $this->_registry = $registry;
        $this->categoryRepository = $categoryRepository;
        $this->exAttLogoHelper = $exAttLogoHelper;
        $this->logger = $logger;
        parent::__construct($context, $data);
    }

    /**
     * Get logo data
     *
     * @return array
     */
    public function getLogoData()
    {
        $showLogo = [];

        try {
            $productdata = $this->getCurrentProduct();
            if ($categoryId = (int) $productdata->getData(Data::MANUFACTURER_LOGO_ATTRIBUTE)) {
                $categoryData = $this->categoryRepository->get($categoryId, $this->exAttLogoHelper->getStoreId());
                $showLogo['logo_url'] = $this->exAttLogoHelper->getLogoMediaUrl($categoryData->getData(Data::MANUFACTURER_LOGO_ATTRIBUTE));
                $showLogo['cat_link'] = $categoryData->getUrl();
                $showLogo['cat_name'] = $categoryData->getName();
                $showLogo['logo_height'] = $this->exAttLogoHelper->getLogoHeight();
                $showLogo['logo_width'] = $this->exAttLogoHelper->getLogoWidth();
                $showLogo['status'] = $this->exAttLogoHelper->getModuleStatus();
            }
        } catch (\Exception $e) {
            $this->logger->debug($e->getMessage());
        }

        return $showLogo;
    }

    /**
     * Get current product
     *
     * @return Registry
     */
    public function getCurrentProduct()
    {
        if ($this->getData('product_data')) {
            return $this->getData('product_data');
        }

        return $this->_registry->registry('current_product');
    }

    /**
     * Get product manufacturer attribute label
     *
     * @param object $productdata
     * @param int|null $storeId
     *
     * @return string
     */
    public function getManufacturerAttributeLabel($productdata, $storeId = 0)
    {
        $attribute = $productdata->getResource()->getAttribute(Data::MANUFACTURER_ATTRIBUTE);

        return $attribute->setStoreId($storeId)->getSource()->getOptionText($productdata->getData(Data::MANUFACTURER_ATTRIBUTE));
    }
}
