<?php
/*
 * web-vision GmbH
 * Do not edit or add to this file if you wish to upgrade Magento to newer
 * versions in the future. If you wish to customize Magento for your
 * needs please refer to https://www.web-vision.de for more information.
 * @category    Extendware
 * @copyright   Copyright (c) 2001-2022 web-vision GmbH (https://www.web-vision.de)
 * @author      Mahesh Makwana <mmakwana@web-vision.de>
 */
namespace Extendware\ManufacturerLogo\Helper;

use Magento\Framework\App\Config\ScopeConfigInterface;
use Magento\Framework\App\Helper\AbstractHelper;
use Magento\Framework\App\Helper\Context;
use Magento\Store\Model\ScopeInterface;
use Magento\Store\Model\StoreManagerInterface;

class Data extends AbstractHelper
{
    public const MANUFACTURER_ATTRIBUTE = 'manufacturer';

    public const MANUFACTURER_LOGO_ATTRIBUTE = 'manufacturer_logo';

    public const ATTRIBUTE_LOGO_SHOW_STATUS = 'ex_manufacturer_logo/general/enable';

    public const LOGO_WIDTH = 'ex_manufacturer_logo/general/logo_height';

    public const LOGO_HEIGHT = 'ex_manufacturer_logo/general/logo_width';

    /**
     * @var StoreManagerInterface
     */
    protected $storeManager;

    /**
     * Init
     *
     * @param Context $context
     * @param ScopeConfigInterface $scopeConfig
     */
    public function __construct(
        Context $context,
        ScopeConfigInterface $scopeConfig,
        StoreManagerInterface $storeManager
    ) {
        $this->scopeConfig = $scopeConfig;
        $this->storeManager = $storeManager;
        parent::__construct($context);
    }

    /**
     * Get module status
     *
     * @return string
     */
    public function getModuleStatus()
    {
        return $this->scopeConfig->getValue(
            self::ATTRIBUTE_LOGO_SHOW_STATUS,
            ScopeInterface::SCOPE_STORE
        );
    }

    /**
     * Get logo height
     *
     * @return string
     */
    public function getLogoHeight()
    {
        return $this->scopeConfig->getValue(
            self::LOGO_WIDTH,
            ScopeInterface::SCOPE_STORE
        );
    }

    /**
     * Get logo width
     *
     * @return string
     */
    public function getLogoWidth()
    {
        return $this->scopeConfig->getValue(
            self::LOGO_HEIGHT,
            ScopeInterface::SCOPE_STORE
        );
    }

    /**
     * Get logo URL
     *
     * @param string|null $fileName
     *
     * @return string|bool
     */
    public function getLogoMediaUrl($fileName)
    {
        if ($fileName) {
            $mediaUrlPath = $this->storeManager->getStore()->getBaseUrl(\Magento\Framework\UrlInterface::URL_TYPE_MEDIA);
            $mediaUrl = str_replace('/media/', $mediaUrlPath, $fileName);

            return $mediaUrl;
        }

        return false;
    }

    /**
     * Get store url
     *
     * @return string
     */
    public function getStoreId()
    {
        return $this->storeManager->getStore()->getId();
    }
}
