<?php
/*
 * web-vision GmbH
 * Do not edit or add to this file if you wish to upgrade Magento to newer
 * versions in the future. If you wish to customize Magento for your
 * needs please refer to https://www.web-vision.de for more information.
 * @category    Extendware
 * @copyright   Copyright (c) 2001-2022 web-vision GmbH (https://www.web-vision.de)
 * @author      Mahesh Makwana <mmakwana@web-vision.de>
 */
namespace Extendware\ProductCategorySlider\Block\Widget;

use Magento\Framework\View\Element\Template;
use Magento\Widget\Block\BlockInterface;

class ShowSlider extends Template implements BlockInterface
{
    /**
     * @var string
     */
    protected $_template = 'Extendware_ProductCategorySlider::widget/ShowSlider.phtml';

    /**
     * @var \Magento\Framework\Registry
     */
    protected $_registry;

    /**
     * @var \Magento\Catalog\Model\CategoryFactory
     */
    protected $categoryFactory;

    /**
     * @var \Magento\Catalog\Api\ProductRepositoryInterface
     */
    protected $productRepository;

    /**
     * @var \Extendware\ProductCategorySlider\Helper\Data
     */
    protected $ewCategorySliderHelper;

    /**
     *
     * @param \Magento\Framework\View\Element\Template\Context $context
     * @param \Magento\Framework\Registry $registry
     * @param \Magento\Catalog\Model\CategoryFactory $categoryFactory
     * @param \Magento\Catalog\Api\ProductRepositoryInterface $productRepository
     * @param \Extendware\ProductCategorySlider\Helper\Data $ewCategorySliderHelper
     * @param array $data
     */
    public function __construct(
        \Magento\Framework\View\Element\Template\Context $context,
        \Magento\Framework\Registry $registry,
        \Magento\Catalog\Model\CategoryFactory $categoryFactory,
        \Magento\Catalog\Api\ProductRepositoryInterface $productRepository,
        \Extendware\ProductCategorySlider\Helper\Data $ewCategorySliderHelper,
        array $data = []
    ) {
        $this->_registry = $registry;
        $this->categoryFactory = $categoryFactory;
        $this->productRepository = $productRepository;
        $this->ewCategorySliderHelper = $ewCategorySliderHelper;
        parent::__construct($context, $data);
    }

    /**
     * Get current product by sku
     *
     * @param string|null $sku
     *
     * @return \Magento\Catalog\Api\ProductRepositoryInterface
     */
    public function getCurrentProduct($sku)
    {
        if ($sku) {
            return $this->getProductBySku($sku);
        }

        return $this->_registry->registry('current_product');
    }

    /**
     * Get category data
     *
     * @param int $catId
     *
     * @return \Magento\Catalog\Model\CategoryFactory
     */
    public function getCategoryData($catId)
    {
        return $this->categoryFactory->create()->load($catId);
    }

    /**
     * Get store id
     *
     * @return int
     */
    public function getStoreId()
    {
        return $this->_storeManager->getStore()->getId();
    }

    /**
     * Get store id
     *
     * @param string $sku
     *
     * @return array|object
     */
    public function getProductBySku($sku)
    {
        try {
            $product = $this->productRepository->get($sku);
        } catch (\Magento\Framework\Exception\NoSuchEntityException $e) {
            $product = [];
        }

        return $product;
    }

    /**
     * Get slider title
     *
     * @param string $title
     *
     * @return string
     */
    public function getSliderTitle($title)
    {
        return  $title ? $title : $this->ewCategorySliderHelper->getDefaultTitle();
    }

    /**
     * Get module status
     *
     * @return string
     */
    public function getModuleStatus()
    {
        return $this->ewCategorySliderHelper->getModuleStatus();
    }
}
