<?php
/*
 * web-vision GmbH
 * Do not edit or add to this file if you wish to upgrade Magento to newer
 * versions in the future. If you wish to customize Magento for your
 * needs please refer to https://www.web-vision.de for more information.
 * @category    Extendware
 * @copyright   Copyright (c) 2001-2022 web-vision GmbH (https://www.web-vision.de)
 * @author      Vaibhav Ahalpara <vaibhav@web-vision.de>
 */
namespace Extendware\ProductCategorySlider\Helper;

use Magento\Framework\App\Config\ScopeConfigInterface;
use Magento\Framework\App\Helper\AbstractHelper;
use Magento\Framework\App\Helper\Context;
use Magento\Store\Model\ScopeInterface;

class Data extends AbstractHelper
{
    public const SLIDER_SHOW_STATUS = 'ex_product_slider/general/enable';

    public const SLIDER_DEFAULT_TITLE = 'ex_product_slider/general/display_text';

    public const SLIDER_MAIN_CAT_ID = 'ex_product_slider/general/root_category';

    /**
     * Init
     *
     * @param Context $context
     * @param ScopeConfigInterface $scopeConfig
     */
    public function __construct(
        Context $context,
        ScopeConfigInterface $scopeConfig
    ) {
        $this->scopeConfig = $scopeConfig;
        parent::__construct($context);
    }

    /**
     * Get module status
     *
     * @return string
     */
    public function getModuleStatus()
    {
        return $this->scopeConfig->getValue(
            self::SLIDER_SHOW_STATUS,
            ScopeInterface::SCOPE_STORE
        );
    }

    /**
     * Get module title
     *
     * @return string
     */
    public function getDefaultTitle()
    {
        return $this->scopeConfig->getValue(
            self::SLIDER_DEFAULT_TITLE,
            ScopeInterface::SCOPE_STORE
        );
    }

    /**
     * Get main category id
     *
     * @return string
     */
    public function getRootCategoryId()
    {
        return $this->scopeConfig->getValue(
            self::SLIDER_MAIN_CAT_ID,
            ScopeInterface::SCOPE_STORE
        );
    }
}
