<?php
/*
 * web-vision GmbH
 * Do not edit or add to this file if you wish to upgrade Magento to newer
 * versions in the future. If you wish to customize Magento for your
 * needs please refer to https://www.web-vision.de for more information.
 * @category    Extendware
 * @copyright   Copyright (c) 2001-2022 web-vision GmbH (https://www.web-vision.de)
 * @author      Mahesh Makwana <mmakwana@web-vision.de>
 */
namespace Extendware\ProductCategorySlider\Model\Config\Source;

use Magento\Catalog\Model\ResourceModel\Category\CollectionFactory as CategoryCollectionFactory;
use Magento\Framework\App\RequestInterface;
use Magento\Framework\Data\OptionSourceInterface;
use Magento\Store\Model\StoreManagerInterface;
use Extendware\ProductCategorySlider\Helper\Data as CategorySilderHelper;

class CategoryList implements OptionSourceInterface
{
    /**
     * @var CategoryCollectionFactory
     */
    protected $categoryCollectionFactory;

    /**
     * @var RequestInterface
     */
    protected $request;

    /**
     * @var array
     */
    protected $parentCategoriesTree;

    /**
     * @var StoreManagerInterface
     */
    protected $storeManager;

    /**
     * @var CategorySilderHelper
     */
    protected $categorySilderHelper;

    /**
     *
     * @param CategoryCollectionFactory $categoryCollectionFactory
     * @param StoreManagerInterface $storeManager
     * @param RequestInterface $request
     * @param CategorySilderHelper $categorySilderHelper
     */
    public function __construct(
        CategoryCollectionFactory $categoryCollectionFactory,
        StoreManagerInterface $storeManager,
        RequestInterface $request,
        CategorySilderHelper $categorySilderHelper
    ) {
        $this->categoryCollectionFactory = $categoryCollectionFactory;
        $this->storeManager = $storeManager;
        $this->request = $request;
        $this->categorySilderHelper = $categorySilderHelper;
    }

    /**
     * Get Option array
     *
     * @return array
     */
    public function toOptionArray()
    {
        return $this->getCategoriesTree();
    }

    /**
     * Get category tree
     *
     * @return array
     */
    protected function getCategoriesTree()
    {
        $getParentCateroyId = $this->getCategoryId();
        if (!$getParentCateroyId) {
            $this->parentCategoriesTree = [];

            return $this->parentCategoriesTree;
        }
        if ($this->parentCategoriesTree === null) {
            $storeId = $this->request->getParam('store');
            // @var $matchingNamesCollection \Magento\Catalog\Model\ResourceModel\Category\Collection
            $matchingNamesCollection = $this->categoryCollectionFactory->create();

            $matchingNamesCollection->addAttributeToSelect('path')
                ->addAttributeToFilter('entity_id', ['neq' => $getParentCateroyId])
                ->setStoreId($storeId);

            $shownCategoriesIds = [];

            /** @var \Magento\Catalog\Model\Category $category */
            foreach ($matchingNamesCollection as $category) {
                foreach (explode('/', $category->getPath()) as $parentId) {
                    $shownCategoriesIds[$parentId] = 1;
                }
            }

            // @var $collection \Magento\Catalog\Model\ResourceModel\Category\Collection
            $collection = $this->categoryCollectionFactory->create();

            $collection->addAttributeToFilter('entity_id', ['in' => array_keys($shownCategoriesIds)])
                ->addAttributeToSelect(['name', 'is_active', 'parent_id'])
                ->setStoreId($storeId);

            $categoryById = [
                $getParentCateroyId => [
                    'value' => $getParentCateroyId,
                ],
            ];

            foreach ($collection as $category) {
                foreach ([$category->getId(), $category->getParentId()] as $categoryId) {
                    if (!isset($categoryById[$categoryId])) {
                        $categoryById[$categoryId] = ['value' => $categoryId];
                    }
                }

                $categoryById[$category->getId()]['is_active'] = $category->getIsActive();
                $categoryById[$category->getId()]['label'] = $category->getName();
                $categoryById[$category->getParentId()]['optgroup'][] = &$categoryById[$category->getId()];
            }

            if (isset($categoryById[$getParentCateroyId]['optgroup'])) {
                $this->parentCategoriesTree = $categoryById[$getParentCateroyId]['optgroup'];
            }
        }

        return $this->parentCategoriesTree;
    }

    /**
     * Get catefory id
     *
     * @return int
     */
    public function getCategoryId()
    {
        return (int) $this->categorySilderHelper->getRootCategoryId();
    }
}
