<?php
/*
 * web-vision GmbH
 * Do not edit or add to this file if you wish to upgrade Magento to newer
 * versions in the future. If you wish to customize Magento for your
 * needs please refer to https://www.web-vision.de for more information.
 * @category    Extendware
 * @copyright   Copyright (c) 2001-2022 web-vision GmbH (https://www.web-vision.de)
 * @author      Mahesh Makwana <mmakwana@web-vision.de>
 */
namespace Extendware\ProductCategorySlider\Plugin\Catalog\Controller\Adminhtml\Product;

use Magento\Catalog\Controller\Adminhtml\Product\Initialization\Helper;
use Magento\Catalog\Model\Product;
use Magento\Framework\App\RequestInterface;

class InitializationPlugin
{
    /**
     * @var RequestInterface
     */
    protected $request;

    /**
     * Constructor
     *
     * @param RequestInterface $request
     */
    public function __construct(
        RequestInterface $request
    ) {
        $this->request = $request;
    }

    /**
     * Creates a product with the given data.
     *
     * @param Helper $subject
     * @param array $result
     * @param Product $product
     *
     * @return array
     */
    public function afterInitialize(Helper $subject, $result, Product $product)
    {
        $productData = $this->request->getPost('product', []);
        if (isset($productData['ew_category_exclude'])) {
            $result->setEwCategoryExclude(implode(',', $productData['ew_category_exclude'] ?? []));
        }

        return $result;
    }
}
