<?php
/*
 * web-vision GmbH
 * Do not edit or add to this file if you wish to upgrade Magento to newer
 * versions in the future. If you wish to customize Magento for your
 * needs please refer to https://www.web-vision.de for more information.
 * @category    Extendware
 * @copyright   Copyright (c) 2001-2022 web-vision GmbH (https://www.web-vision.de)
 * @author      Mahesh Makwana <mmakwana@web-vision.de>
 */
namespace Extendware\ProductCategorySlider\Ui\DataProvider\Product\Form\Modifier;

use Magento\Catalog\Ui\DataProvider\Product\Form\Modifier\AbstractModifier;
use Magento\Ui\Component\Form\Field;

class CustomCategoryIds extends AbstractModifier
{
    /**
     * @var \Magento\Catalog\Model\Locator\LocatorInterface
     */
    private $locator;

    /**
     * @var \Extendware\ProductCategorySlider\Model\Config\Source\CategoryList
     */
    private $showCategoryList;

    /**
     *
     * @param \Extendware\ProductCategorySlider\Model\Config\Source\CategoryList $showCategoryList
     * @param \Magento\Catalog\Model\Locator\LocatorInterface $locator
     */
    public function __construct(
        \Extendware\ProductCategorySlider\Model\Config\Source\CategoryList $showCategoryList,
        \Magento\Catalog\Model\Locator\LocatorInterface $locator
    ) {
        $this->showCategoryList = $showCategoryList;
        $this->locator = $locator;
    }

    /**
     * @inheritDoc
     */
    public function modifyMeta(array $meta)
    {
        // Add CMS Category Field
        if (isset($meta['product-details']['children']['container_ew_category_exclude']['children']['ew_category_exclude'])) {
            $meta['product-details']['children']['container_ew_category_exclude']['children']['ew_category_exclude']['arguments']['data']['config']['component'] = 'Magento_Catalog/js/components/new-category';
            $meta['product-details']['children']['container_ew_category_exclude']['children']['ew_category_exclude']['arguments']['data']['config']['elementTmpl'] = 'ui/grid/filters/elements/ui-select';
            $meta['product-details']['children']['container_ew_category_exclude']['children']['ew_category_exclude']['arguments']['data']['config']['levelsVisibility'] = 1;
            $meta['product-details']['children']['container_ew_category_exclude']['children']['ew_category_exclude']['arguments']['data']['config']['disableLabel'] = 1;
            $meta['product-details']['children']['container_ew_category_exclude']['children']['ew_category_exclude']['arguments']['data']['config']['chipsEnabled'] = 1;
            $meta['product-details']['children']['container_ew_category_exclude']['children']['ew_category_exclude']['arguments']['data']['config']['options'] = $this->getCMSCategories();
            $meta['product-details']['children']['container_ew_category_exclude']['children']['ew_category_exclude']['arguments']['data']['config']['filterOptions'] = 1;
        }

        return $meta;
    }

    /**
     * Get all categories
     *
     * @return array
     */
    public function getCMSCategories()
    {
        return $this->showCategoryList->toOptionArray();
    }

    /**
     * @inheritDoc
     */
    public function modifyData(array $data)
    {
        $product = $this->locator->getProduct();
        $productId = (int) $product->getId();
        $cmsCategoryIds = '';
        if ($product->getEwCategoryExclude()) {
            $cmsCategoryIds = $product->getEwCategoryExclude();
        }

        $data = array_replace_recursive(
            $data,
            [
                $productId => [
                    'product' => [
                        'ew_category_exclude' => $cmsCategoryIds,
                    ],
                ],
            ]
        );

        return $data;
    }
}
