<?php
/*
 web-vision GmbH
 Do not edit or add to this file if you wish to upgrade Magento to newer
 versions in the future. If you wish to customize Magento for your
 needs please refer to https://www.web-vision.de for more information.
 @category    Extendware
 @copyright   Copyright (c) 2001-2023 web-vision GmbH (https://www.web-vision.de)
 @author      Fenil Timbadiya <fenil@web-vision.de>
*/
namespace Extendware\Quickorder\Block;

use Magento\Framework\View\Element\Template\Context;
use Magento\Framework\Registry;
use Magento\Framework\App\Http\Context as HttpContext;
use Magento\Catalog\Model\ResourceModel\Product;
use Extendware\Quickorder\Helper\Data;
use Magento\Framework\Data\Form\FormKey;
use Magento\Framework\UrlInterface;

class View extends \Magento\Framework\View\Element\Template
{
    /**
     * @var Registry $_coreRegistry
     */
    protected $_coreRegistry = null;

    /**
     * @var HttpContext $httpContext
     */
    protected $httpContext;

    /**
     * @var Product $helper
     */
    protected $product;

    /**
     * @var Data $helper
     */
    protected $helper;

    /**
     * @var FormKey $formKey
     */
    protected $formKey;

    /**
     * @var UrlInterface $urlBuilder
     */
    protected $urlBuilder;

    /**
     * __construct function
     *
     * @param Context $context
     * @param Registry $registry
     * @param HttpContext $httpContext
     * @param Product $product
     * @param Data $helper
     * @param FormKey $formKey
     * @param UrlInterface $urlBuilder
     * @param array $data
     */
    public function __construct(
        Context $context,
        Registry $registry,
        HttpContext $httpContext,
        Product $product,
        Data $helper,
        FormKey $formKey,
        UrlInterface $urlBuilder,
        array $data = []
    ) {
        $this->_coreRegistry = $registry;
        $this->httpContext = $httpContext;
        $this->product = $product;
        $this->helper = $helper;
        $this->formKey = $formKey;
        $this->urlBuilder = $urlBuilder;
        parent::__construct($context, $data);
    }

    /**
     * Prepare layout and set title
     *
     * @return void
     */
    protected function _prepareLayout()
    {
        $this->pageConfig->getTitle()->set(__('Quick Order'));
    }

    /**
     * Get Page Title
     *
     * @return void
     */
    public function getPageTitle()
    {
        return $this->pageConfig->getTitle()->get();
    }

    /**
     * Retrieve current order model instance
     *
     * @return \Magento\Sales\Model\Order
     */
    public function getOrder()
    {
        return $this->_coreRegistry->registry('current_order');
    }

    /**
     * Returns url for place quick order
     *
     * @param object $order
     *
     * @return string
     */
    public function getPlaceQuickorderUrl()
    {
        return $this->urlBuilder->getUrl('quickorder/order/place');
    }

    /**
     * Get Sku Saggesstion Url function
     *
     * @param $productSku
     *
     * @return void
     */
    public function getSkuSaggesstionUrl()
    {
        return $this->urlBuilder->getUrl('quickorder/product/skusuggestions');
    }

    /**
     * Get Product Detail Url
     *
     * @param $productSku
     *
     * @return void
     */
    public function getProductDetailUrl()
    {
        return $this->urlBuilder->getUrl('quickorder/product/productdetails');
    }

    /**
     * GetPlaceholder function
     *
     * @return void
     */
    public function getPlaceholder()
    {
        $placeholders = $this->product->getAttribute('sku')->getStoreLabel();
        $attributeCode = $this->helper->getConfigAttributeCode();
        if (!empty($attributeCode)) {
            $placeholders = $attributeCode;
        }

        return $placeholders;
    }

    /**
     * GetOrderMethodText function
     *
     * @return void
     */
    public function getOrderMethodText()
    {
        $orderMethod = $this->helper->getOrderMethod();

        if ($orderMethod === 'cart') {
            return __('Add to Cart');
        }

        return __('Place Order');
    }

    /**
     * GetFormKey function
     *
     * @return void
     */
    public function getFormKey()
    {
        return $this->formKey->getFormKey();
    }

    /**
     * Get Helper Data function
     *
     * @return void
     */
    public function getHelperData()
    {
        return $this->helper;
    }
}
