<?php
/*
 web-vision GmbH
 Do not edit or add to this file if you wish to upgrade Magento to newer
 versions in the future. If you wish to customize Magento for your
 needs please refer to https://www.web-vision.de for more information.
 @category    Extendware
 @copyright   Copyright (c) 2001-2023 web-vision GmbH (https://www.web-vision.de)
 @author      Fenil Timbadiya <fenil@web-vision.de>
*/

namespace Extendware\Quickorder\Controller\Product;

use Extendware\Quickorder\Helper\Data as QuickorderHelper;
use Magento\Catalog\Model\ProductRepository;
use Magento\Framework\App\Action\Action;
use Magento\Framework\App\Action\Context;
use Magento\Framework\Controller\Result\JsonFactory;
use Magento\Framework\Pricing\Helper\Data as PricingHelper;
use Psr\Log\LoggerInterface;

class ProductDetails extends Action
{

    /**
     * @var JsonFactory
     */
    private $resultJsonFactory;

    /**
     * @var ProductRepository
     */
    protected $productRepository;

    /**
     * @var PricingHelper
     */
    protected $pricingHelper;

    /**
     * @var LoggerInterface
     */
    private $logger;

    /**
     * @var QuickorderHelper $quickorderhelper
     */
    protected $quickorderhelper;

    /**
     * __construct function
     *
     * @param Context $context
     * @param JsonFactory $resultJsonFactory
     * @param ProductRepository $productRepository
     * @param PricingHelper $pricingHelper
     * @param LoggerInterface $logger
     * @param QuickorderHelper $quickorderhelper
     */
    public function __construct(
        Context $context,
        JsonFactory $resultJsonFactory,
        ProductRepository $productRepository,
        PricingHelper $pricingHelper,
        LoggerInterface $logger,
        QuickorderHelper $quickorderhelper
    ) {
        parent::__construct($context);
        $this->resultJsonFactory = $resultJsonFactory;
        $this->productRepository = $productRepository;
        $this->pricingHelper = $pricingHelper;
        $this->logger = $logger;
        $this->quickorderhelper = $quickorderhelper;
    }

    /**
     * Execute
     *
     * @return void
     */
    public function execute()
    {
        $sku = $this->getRequest()->getParam('sku');
        $result = $this->resultJsonFactory->create();
        try {
            if ($sku) {
                $product = $this->productRepository->get($sku);
                $productPrice = $product->getPrice();
                // Format the price
                $formattedPrice = $this->pricingHelper->currency($productPrice, true, false);
                $productdetails = [
                    'sku' => $sku,
                    'name' => $product->getName(),
                    'price' => $formattedPrice,
                ];

                return $result->setData(['productdetails' => $productdetails]);
            }

            return $result->setData(['error' => 'Invalid input']);
        } catch (\Magento\Framework\Exception\LocalizedException $e) {
            return $result->setData(['error' => $e->getMessage()]);
        } catch (\Exception $e) {
            $this->logger->critical($e);
            return $result->setData(['error' => $e->getMessage()]);
        }
    }
}
