<?php
/*
 web-vision GmbH
 Do not edit or add to this file if you wish to upgrade Magento to newer
 versions in the future. If you wish to customize Magento for your
 needs please refer to https://www.web-vision.de for more information.
 @category    Extendware
 @copyright   Copyright (c) 2001-2023 web-vision GmbH (https://www.web-vision.de)
 @author      Fenil Timbadiya <fenil@web-vision.de>
*/

namespace Extendware\Quickorder\Controller\Product;

use Extendware\Quickorder\Helper\Data as QuickorderHelper;
use Magento\Catalog\Model\ResourceModel\Product\CollectionFactory;
use Magento\Framework\App\Action\Action;
use Magento\Framework\App\Action\Context;
use Magento\Framework\Controller\Result\JsonFactory;
use Psr\Log\LoggerInterface;

class SkuSuggestions extends Action
{

    /**
     * @var JsonFactory
     */
    private $resultJsonFactory;

    /**
     * @var CollectionFactory
     */
    protected $productCollectionFactory;

    /**
     * @var LoggerInterface
     */
    private $logger;

    /**
     * @var QuickorderHelper $quickorderhelper
     */
    protected $quickorderhelper;

    /**
     * __construct function
     *
     * @param Context $context
     * @param JsonFactory $resultJsonFactory
     * @param CollectionFactory $productCollectionFactory
     * @param LoggerInterface $logger
     * @param QuickorderHelper $quickorderhelper
     */
    public function __construct(
        Context $context,
        JsonFactory $resultJsonFactory,
        CollectionFactory $productCollectionFactory,
        LoggerInterface $logger,
        QuickorderHelper $quickorderhelper
    ) {
        parent::__construct($context);
        $this->resultJsonFactory = $resultJsonFactory;
        $this->productCollectionFactory = $productCollectionFactory;
        $this->logger = $logger;
        $this->quickorderhelper = $quickorderhelper;
    }

    /**
     * Execute
     *
     * @return void
     */
    public function execute()
    {
        $sku = $this->getRequest()->getParam('input');
        $result = $this->resultJsonFactory->create();
        try {
            if ($sku && strlen($sku) > 2) {
                $collection = $this->productCollectionFactory->create();
                $collection->addAttributeToSelect('sku');
                $collection->addFieldToFilter('sku', ['like' => '%' . $sku . '%']);
                $suggestions = $collection->getColumnValues('sku');

                return $result->setData(['suggestions' => $suggestions]);
            }

            return $result->setData(['error' => 'Invalid input']);
        } catch (\Magento\Framework\Exception\LocalizedException $e) {
            return $result->setData(['error' => $e->getMessage()]);
        } catch (\Exception $e) {
            $this->logger->critical($e);
            return $result->setData(['error' => $e->getMessage()]);
        }
    }
}
