<?php
/*
 web-vision GmbH
 Do not edit or add to this file if you wish to upgrade Magento to newer
 versions in the future. If you wish to customize Magento for your
 needs please refer to https://www.web-vision.de for more information.
 @category    Extendware
 @copyright   Copyright (c) 2001-2023 web-vision GmbH (https://www.web-vision.de)
 @author      Fenil Timbadiya <fenil@web-vision.de>
*/

namespace Extendware\Quickorder\Setup\Patch\Data;

use Extendware\Core\Api\Data\ExtendwareModuleInterfaceFactory;
use Extendware\Core\Api\ExtendwareModuleRepositoryInterface;
use Magento\Framework\Setup\ModuleDataSetupInterface;
use Magento\Framework\Setup\Patch\DataPatchInterface;
use Magento\Framework\Setup\Patch\PatchRevertableInterface;

class SetDataModule implements
    DataPatchInterface,
    PatchRevertableInterface
{
    /**
     * @var ModuleDataSetupInterface $moduleDataSetup
     */
    private $moduleDataSetup;

    /**
     * @var ExtendwareModuleInterfaceFactory
     */
    protected $extendwareModuleFactory;

    /**
     * @var ExtendwareModuleRepositoryInterface
     */
    protected $extendwareModuleRepository;

    /**
     * @param ModuleDataSetupInterface $moduleDataSetup
     * @param ExtendwareModuleInterfaceFactory $extendwareModuleFactory
     * @param ExtendwareModuleRepositoryInterface $extendwareModuleRepository
     */
    public function __construct(
        ModuleDataSetupInterface            $moduleDataSetup,
        ExtendwareModuleInterfaceFactory    $extendwareModuleFactory,
        ExtendwareModuleRepositoryInterface $extendwareModuleRepository
    ) {
        $this->moduleDataSetup = $moduleDataSetup;
        $this->extendwareModuleFactory = $extendwareModuleFactory;
        $this->extendwareModuleRepository = $extendwareModuleRepository;
    }

    /**
     * Do Upgrade
     *
     * @return void
     * @throws \Magento\Framework\Exception\CouldNotSaveException
     */
    public function apply()
    {
        $this->moduleDataSetup->startSetup();
        /**
         * @var \Extendware\Core\Api\Data\ExtendwareModuleInterface $extendModule
         */
        $extendModule = $this->extendwareModuleFactory->create();
        //MODULE NAME SAME AS THE NAME IN PRODUCT
        $extendModule->setModuleName('Extendware_Quickorder');
        //MODULE ACTIVE STATUS
        $extendModule->setModuleActive(1);
        $this->extendwareModuleRepository->save($extendModule);
        $this->moduleDataSetup->endSetup();
    }

    /**
     * @inheritdoc
     */
    public function revert()
    {
    }

    /**
     * @inheritdoc
     */
    public function getAliases()
    {
        return [];
    }

    /**
     * @inheritdoc
     */
    public static function getDependencies()
    {
        return [];
    }
}
