<?php
/*
 *
 *  * web-vision GmbH
 *  * Do not edit or add to this file if you wish to upgrade Magento to newer
 *  * versions in the future. If you wish to customize Magento for your
 *  * needs please refer to https://www.web-vision.de for more information.
 *  * @category    WebVision
 *  * @copyright   Copyright (c) 2001-2022 web-vision GmbH (https://www.web-vision.de)
 *  * @author      Parth Trivedi <parth@web-vision.de>
 *
 *
 */

declare(strict_types=1);
namespace Extendware\RestrictFakeRegistration\Plugin\Magento\Customer\Model;

use Magento\Framework\App\State as Area;
use Magento\Framework\Exception\LocalizedException;
use Magento\Customer\Helper\View as CustomerViewHelper;

class AccountManagement
{
    /**
     * @param Area $area
     * @param array $allowedAreas
     */
    public function __construct(
        private Area $area,
        private customerViewHelper $customerViewHelper,
        private array $allowedAreas = []
    ) {
    }

    /**
     * @param \Magento\Customer\Model\AccountManagement $subject
     * @param $customer
     * @param $password
     * @param $redirectUrl
     *
     * @throws LocalizedException
     *
     * @return array
     */
    public function beforeCreateAccount(
        \Magento\Customer\Model\AccountManagement $subject,
                                                  $customer,
                                                  $password = null,
                                                  $redirectUrl = ''
    ) {
        if (!in_array($this->area->getAreaCode(), $this->allowedAreas)) {
            throw new LocalizedException(
                __($this->area->getAreaCode() . ' customer creation is not allowed')
            );
        }

        //name validations
        $customerName = $this->customerViewHelper->getCustomerName($customer);
        if($this->containsChinese($customerName)) {
            throw new LocalizedException(
                __('customer creation is not allowed - correct field entries')
            );
        }

        return [$customer, $password, $redirectUrl];
    }

    public function containsChinese($string) {
        return preg_match('/[\x{4e00}-\x{9fff}]/u', $string);
    }

}
