<?php
/*
 *
 *  * web-vision GmbH
 *  * Do not edit or add to this file if you wish to upgrade Magento to newer
 *  * versions in the future. If you wish to customize Magento for your
 *  * needs please refer to https://www.web-vision.de for more information.
 *  * @copyright   Copyright (c) 2001-2023 web-vision GmbH (https://www.web-vision.de)
 *  * @author      Fenil Timbadiya
 *
 */
namespace Mzat\AdditionalHeaderNavigation\Block;

use Magento\Framework\App\Config\ScopeConfigInterface;
use Magento\Framework\View\Element\Template\Context;

/**
 * AdditionalHeaderNavigation class
 */
class AdditionalHeaderNavigation extends \Magento\Framework\View\Element\Template
{
    public const XML_PATH_NAVIGATION = 'additionalheadernavigation/general/navigation';

    protected $scopeConfig;

    public function __construct(
        Context $context,
        ScopeConfigInterface $scopeConfig,
        array $data = []
    ) {
        parent::__construct($context, $data);
        $this->scopeConfig = $scopeConfig;
    }

    /**
     * GetConfig function
     *
     * @return void
     */
    public function getConfig()
    {
        $config_value = (array) json_decode($this->scopeConfig->getValue(self::XML_PATH_NAVIGATION, \Magento\Store\Model\ScopeInterface::SCOPE_STORE));

        return $config_value;
    }
}
