<?php
/*
 *
 *  * web-vision GmbH
 *  * Do not edit or add to this file if you wish to upgrade Magento to newer
 *  * versions in the future. If you wish to customize Magento for your
 *  * needs please refer to https://www.web-vision.de for more information.
 *  * @copyright   Copyright (c) 2001-2023 web-vision GmbH (https://www.web-vision.de)
 *  * @author      Fenil Timbadiya
 *
 */
declare(strict_types=1);
namespace Mzat\AdditionalHeaderNavigation\ViewModel;

use Magento\Catalog\Model\ResourceModel\Category\CollectionFactory;
use Magento\Store\Model\StoreManagerInterface;

class CategoryMenuAlignment implements \Magento\Framework\View\Element\Block\ArgumentInterface
{
    /**
     * @var CollectionFactory
     */
    private $categoryFactory;

    /**
    * @var \Magento\Store\Model\StoreManagerInterface
    */
    private $storeManager;

    /**
     * CategoryDescriptions constructor.
     *
     * @param CollectionFactory $categoryFactory
     * @param StoreManagerInterface $storeManager
     */
    public function __construct(
        CollectionFactory $categoryFactory,
        StoreManagerInterface $storeManager
    ) {
        $this->categoryFactory = $categoryFactory;
        $this->storeManager = $storeManager;
    }

    /**
     * Get Category Menu Alignment
     *
     * @param $category_node
     *
     * @return bool
     */
    public function getCategoryMenuAlignment($category_node)
    {
        $categoryMenuAlignments = $this->categoryFactory->create()
            ->addAttributeToSelect(['category_menu_alignment'])->addAttributeToFilter('category_menu_alignment', ['eq' => '2'])
            ->setStore($this->storeManager->getStore()->getId());
        if (array_search(intval(trim($category_node, 'category-node-')), array_column($categoryMenuAlignments->getData(), 'entity_id')) !== false) {
            return true;
        }

        return false;
    }

    public function getMenuDesignClass($category_node)
    {
        $categoryId = intval(trim($category_node, 'category-node-'));

        $category = $this->categoryFactory->create()
            ->addAttributeToSelect(['custom_category_class'])
            ->addAttributeToFilter('entity_id', ['eq' => $categoryId])
            ->setStore($this->storeManager->getStore()->getId())
            ->getFirstItem();

        return $category->getCustomCategoryClass();
    }

}
