<?php
/**
 * @category  Extendware
 *
 * @copyright 2020 Extendware
 */
declare(strict_types=1);
namespace Mzat\AskQuestion\Helper;

use Magento\Framework\App\Config\ScopeConfigInterface;
use Magento\Framework\App\Helper\AbstractHelper;
use Magento\Framework\Mail\Template\TransportBuilder;
use Magento\Framework\Translate\Inline\StateInterface;
use Magento\Store\Model\ScopeInterface;
use Magento\Store\Model\StoreManagerInterface;

class Data extends AbstractHelper
{
    protected $transportBuilder;
    protected $storeManager;
    protected $inlineTranslation;
    protected $scopeConfig;

    /**
     * @param \Magento\Framework\App\Helper\Context $context
     */
    public function __construct(
        \Magento\Framework\App\Helper\Context $context,
        TransportBuilder $transportBuilder,
        StoreManagerInterface $storeManager,
        ScopeConfigInterface $scopeConfig,
        StateInterface $state
    ) {
        $this->transportBuilder = $transportBuilder;
        $this->storeManager = $storeManager;
        $this->scopeConfig = $scopeConfig;
        $this->inlineTranslation = $state;
        parent::__construct($context);
    }

    /**
     * @return bool
     */
    public function isEnabled()
    {
        return $this->scopeConfig->getValue('askquestion/general/enable', \Magento\Store\Model\ScopeInterface::SCOPE_STORE);
    }

    public function getPopupContent()
    {
        return $this->scopeConfig->getValue('askquestion/general/content', \Magento\Store\Model\ScopeInterface::SCOPE_STORE);
    }

    /**
     * @return array
     */
    public function getAdminCustomEmail()
    {
        $data = [];
        $data['name'] = $this->scopeConfig->getValue('trans_email/ident_support/name', ScopeInterface::SCOPE_STORE);
        if ($this->scopeConfig->getValue('askquestion/custom_email_askquestion/enable_email', \Magento\Store\Model\ScopeInterface::SCOPE_STORE)) {
            $data['email'] = $this->scopeConfig->getValue('askquestion/custom_email_askquestion/email_address', ScopeInterface::SCOPE_STORE);
        } else {
            $data['email'] = $this->scopeConfig->getValue('trans_email/ident_support/email', ScopeInterface::SCOPE_STORE);
        }

        return $data;
    }

    public function sendAnswerEmail($email, $answer, $question, $createdAt)
    {
        $adminEmail = $this->scopeConfig->getValue('trans_email/ident_support/email', ScopeInterface::SCOPE_STORE);
        $adminName = $this->scopeConfig->getValue('trans_email/ident_support/name', ScopeInterface::SCOPE_STORE);

        $fromEmail = $adminEmail;
        $fromName = $adminName;
        $toEmail = $email;

        try {
            // template variables pass here
            $templateId = 'question_answer_template';
            $templateVars = [
                'answer' => $answer,
                'question' => $question,
                'createdAt' => $createdAt,
            ];

            $storeId = $this->storeManager->getStore()->getId();

            $from = ['email' => $fromEmail, 'name' => $fromName];
            $this->inlineTranslation->suspend();

            $storeScope = \Magento\Store\Model\ScopeInterface::SCOPE_STORE;
            $templateOptions = [
                'area' => \Magento\Framework\App\Area::AREA_FRONTEND,
                'store' => $storeId,
            ];
            $transport = $this->transportBuilder->setTemplateIdentifier($templateId, $storeScope)
                ->setTemplateOptions($templateOptions)
                ->setTemplateVars($templateVars)
                ->setFrom($from)
                ->addTo($toEmail)
                ->getTransport();
            $transport->sendMessage();
            $this->inlineTranslation->resume();
        } catch (\Exception $e) {
            $this->_logger->info($e->getMessage());
        }
    }

    public function sendEmailToAdmin($userEmail, $userName, $userLastName, $userCompany, $productSku, $question, $subject)
    {
        $data = $this->getAdminCustomEmail();
        $adminEmail = $this->scopeConfig->getValue('trans_email/ident_support/email', ScopeInterface::SCOPE_STORE);
        $adminName = $this->scopeConfig->getValue('trans_email/ident_support/name', ScopeInterface::SCOPE_STORE);

        try {
            // template variables pass here
            $templateId = 'customer_query_template';
            $templateVars = [
                'fromUserEmail' => $userEmail,
                'query' => $question,
                'productSku' => $productSku,
                'fromUser' => $userName,
                'fromUserLastName' => $userLastName,
                'fromUserCompany' => $userCompany,
                'subject' => $subject,
            ];

            $storeId = $this->storeManager->getStore()->getId();

            $from = ['email' => $adminEmail, 'name' => $adminName];
            $this->inlineTranslation->suspend();

            $storeScope = \Magento\Store\Model\ScopeInterface::SCOPE_STORE;
            $templateOptions = [
                'area' => \Magento\Framework\App\Area::AREA_FRONTEND,
                'store' => $storeId,
            ];
            $transport = $this->transportBuilder->setTemplateIdentifier($templateId, $storeScope)
                ->setTemplateOptions($templateOptions)
                ->setTemplateVars($templateVars)
                ->setFrom($from)
                ->addTo($data['email'])
                ->setReplyTo($userEmail)
                ->getTransport();
            $transport->sendMessage();
            $this->inlineTranslation->resume();
        } catch (\Exception $e) {
            $this->_logger->info($e->getMessage());
        }
    }

    public function sendNotificationEmailToCustomer($userEmail, $productSku, $question, $subject)
    {
        $adminEmail = $this->scopeConfig->getValue('trans_email/ident_support/email', ScopeInterface::SCOPE_STORE);
        $adminName = $this->scopeConfig->getValue('trans_email/ident_support/name', ScopeInterface::SCOPE_STORE);

        try {
            // template variables pass here
            $templateId = 'customer_notification_template';
            $templateVars = [
                'query' => $question,
                'productSku' => $productSku,
                'subject' => $subject,
            ];

            $storeId = $this->storeManager->getStore()->getId();

            $from = ['email' => $adminEmail, 'name' => $adminName];
            $this->inlineTranslation->suspend();

            $storeScope = \Magento\Store\Model\ScopeInterface::SCOPE_STORE;
            $templateOptions = [
                'area' => \Magento\Framework\App\Area::AREA_FRONTEND,
                'store' => $storeId,
            ];
            $transport = $this->transportBuilder->setTemplateIdentifier($templateId, $storeScope)
                ->setTemplateOptions($templateOptions)
                ->setTemplateVars($templateVars)
                ->setFrom($from)
                ->addTo($userEmail)
                ->setReplyTo($adminEmail)
                ->getTransport();
            $transport->sendMessage();
            $this->inlineTranslation->resume();
        } catch (\Exception $e) {
            $this->_logger->info($e->getMessage());
        }
    }
}
