<?php
/*
 * web-vision GmbH
 * Do not edit or add to this file if you wish to upgrade Magento to newer
 * versions in the future. If you wish to customize Magento for your
 * needs please refer to https://www.web-vision.de for more information.
 * @category    Mzat
 * @copyright   Copyright (c) 2001-2022 web-vision GmbH (https://www.web-vision.de)
 * @author      Mahesh Makwana <mmakwana@web-vision.de>
 */
namespace Mzat\AutoReindex\Cron;

use Magento\Framework\App\Cache\Frontend\Pool;
use Magento\Framework\App\Cache\TypeListInterface;
use Magento\Indexer\Model\IndexerFactory;
use Mzat\AutoReindex\Logger\Logger as AutoReindexLogger;

class AutoReindexCron
{
    /**
     * @var array
     */
    protected $cacheType = [
        'layout',
        'block_html',
        'collections',
        'db_ddl',
        'eav',
        'full_page',
    ];

    /**
     * @var array
     */
    protected $indexType = [
        'design_config_grid',
        'customer_grid',
        'catalog_category_product',
        'catalog_product_category',
        'catalogrule_rule',
        'catalog_product_attribute',
        'cataloginventory_stock',
        'catalog_product_price',
        'catalogrule_product',
        'catalogsearch_fulltext',
        'elasticsuite_categories_fulltext',
    ];

    /**
     * @var AutoReindexLogger
     */
    protected $logger;

    /**
     * @var IndexerFactory
     */
    protected $indexFactory;

    /**
     * @var TypeListInterface
     */
    protected $cacheTypeList;

    /**
     * @var Pool
     */
    protected $cacheFrontendPool;

    /**
     * @param AutoReindexLogger $logger
     * @param IndexerFactory $indexFactory
     * @param TypeListInterface $cacheTypeList
     * @param Pool $cacheFrontendPool
     */
    public function __construct(
        AutoReindexLogger $logger,
        IndexerFactory $indexFactory,
        TypeListInterface $cacheTypeList,
        Pool $cacheFrontendPool
    ) {
        $this->logger = $logger;
        $this->indexFactory = $indexFactory;
        $this->cacheTypeList = $cacheTypeList;
        $this->cacheFrontendPool = $cacheFrontendPool;
    }

    /**
     * Execute
     *
     * @return void
     */
    public function execute()
    {
        $this->logger->info('Auto Reindex Start');
        $this->logger->info('Reindexing Started');
        foreach ($this->indexType as $indexid) {
            try {
                $indexidarray = $this->indexFactory->create()->load($indexid);
                $this->logger->info('Reindex: ' . $indexidarray->getTitle() . ' Start');
                $indexidarray->reindexRow($indexid);
                $this->logger->info('Reindex: ' . $indexidarray->getTitle() . ' over');
            } catch (\Exception $e) {
                $this->logger->error('Reindex Error ' . $e->getMessage() . ' over');
            }
        }
        $this->logger->info('Reindexing over');

        $this->logger->info('Cache Refresh');

        foreach ($this->cacheType as $type) {
            $this->cacheTypeList->cleanType($type);
        }
        foreach ($this->cacheFrontendPool as $cacheFrontend) {
            $cacheFrontend->getBackend()->clean();
        }
        $this->logger->info('Auto Reindex over');
    }
}
